/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.bmx;

import de.babtec.globals.jobdata.BMXBasicJobData;
import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.utils.ByteConv;
import java.nio.charset.Charset;
import java.util.Random;

public class BMXPackets {
    public static final int BMX_Identification = 0;
    public static final int BMX_Connect = 1;
    public static final int BMX_Disconnect = 2;
    public static final int BMX_Telegram = 4;
    public static final int BMX_GetTeleTable = 6;
    public static final int BMX_BusOnline = 8;
    public static final int BMX_BusOffline = 9;
    public static final int BMX_Ping = 10;
    public static final int BMX_Pong = 11;
    public static final int BMX_GetSystem = 30;
    public static final int BMX_SetSystem = 31;
    public static final int BMX_ServerConnections = 40;
    public static final int BMX_ServerProtokoll = 41;
    public static final int BMX_DriverProtokoll = 42;
    public static final int BMX_TraceListe = 43;
    public static final int BMX_Config = 53;
    public static final int BMX_AutoPossibility = 100;
    public static final int BMX_AutoListe = 101;
    public static final int BMX_GetAutoItem = 102;
    public static final int BMX_StoreAutoItem = 103;
    public static final int BMX_AddAutoItem = 104;
    public static final int BMX_DeleteAutoItem = 105;
    public static final int BMX_ChangeAutoItem = 110;
    public static final int BMX_GetProviderList = 120;
    public static final int BMX_GetProviderItem = 121;
    public static final int BMX_SetProviderItem = 122;
    public static final int BMX_Crypto = 123;
    public static final int BMX_TraceListeFiltered = 124;
    public static final int BMX_RAPdata = 125;
    public static final int BMX_AstroFunction = 126;
    public static final int BMX_GetParameter = 127;
    public static final int BMX_EnOcean = 129;
    public static final int BMX_Authentication = 130;
    public static final int BMX_RAPdata_request_lock = 1;
    public static final int BMX_RAPdata_request_unlock = 2;
    public static final int BMX_RAPdata_response_success = 16;
    public static final int BMX_RAPdata_response_invalid = 17;
    public static final int BMX_RAPdata_response_locked = 18;
    public static final int BMX_SetSystem_EP_TIME = 1;
    public static final int BMX_SetSystem_CLEAR_STATETABLE = 2;
    public static final int BMX_SetSystem_CLEAR_HISTORY = 3;
    public static final int BMX_SetSystem_START_RESCUE = 6;
    public static final int BMX_SetSystem_ENOCEAN_LOCK = 7;
    public static final int BMX_SetSystem_ENOCEAN_UNLOCK = 8;
    public static final int BMX_SetSystem_LOGIN_ID = 9;
    public static final int BMX_GetSystem_EP_TIME = 1;
    public static final int BMX_GetSystem_STATE_TABLE_STAT = 2;
    public static final int BMX_GetSystem_SERNR = 3;
    public static final int BMX_GetSystem_FLASH_STAT = 4;
    public static final int BMX_GetSystem_NETWORK = 5;
    public static final int BMX_GetSystem_EIB_PHYS_ADR = 6;
    public static final int BMX_GetSystem_DNS_SERVER = 7;
    public static final int BMX_GetSystem_NTP_SERVER = 8;
    public static final int BMX_GetSystem_UPTIME = 9;
    public static final int BMX_GetSystem_CPU_LOAD = 10;
    public static final int BMX_GetSystem_KNXNI_ROUTING = 11;
    public static final int BMX_GetSystem_KNXNI_TUNNELING = 12;
    public static final int BMX_GetSystem_ABBNI = 13;
    public static final int BMX_GetSystem_RAM_STAT = 14;
    public static final int BMX_GetSystem_GET_ENOCEAN_INFO = 15;
    public static final int BMX_GetSystem_VALIDATE_SSH_TOKEN = 16;
    public static final int BMX_Config_Version = 2;
    public static final int BMX_Config_Type_nw = 1;
    public static final int BMX_Config_Max_Data_Version2 = 100;
    public static final String[] BMXINDEX_RETURN = new String[]{"action successfully performed", "invalid packet-length (0x0001)", "server cannot find the job (0x0002)", "a job with this name already exists (0x0003)", "this job is not supported by this server-version (0x0004)", "the server does not have enouth memory to perform this action (0x0005)"};
    public static final byte IDENTIFICATION_NAME = 0;
    public static final byte IDENTIFICATION_VERSION = 1;
    public static final byte IDENTIFICATION_PROTOCOL = 2;
    public static final byte IDENTIFICATION_PROTOCOLVERSION = 3;
    public static final int BMX_EnOcean_RAW_FROM_ENOCEAN = 1;
    public static final int BMX_EnOcean_RAW_TO_ENOCEAN = 2;
    public static final int BMX_EnOcean_RAW_CONNECT = 3;
    public static final int BMX_EnOcean_RAW_DISCONNECT = 4;
    public static final byte[] STATUS_1BIT_EXTERN_SWITCH = new byte[]{97, 0};
    public static final byte[] STATUS_4BIT_EXTERN_SWITCH = new byte[]{100, 0};
    public static final byte[] STATUS_1BYTE_EXTERN = new byte[]{101, 0};
    public static final byte[] STATUS_2BYTE_EXTERN = new byte[]{102, 0};
    public static final byte[] STATUS_3BYTE_EXTERN = new byte[]{103, 0};
    public static final byte[] STATUS_4BYTE_EXTERN = new byte[]{104, 0};
    public static final byte[] STATUS_16BYTE_EXTERN = new byte[]{111, 0};
    public static final int STATUS_TYPE_INT_FRAGE = 0;
    public static final int STATUS_TYPE_INT_ANTWORT = 1;
    public static final int STATUS_TYPE_INT_SCHALT = 2;
    public static final int STATUS_TYPE_INT_EX_FRAGE = 3;
    public static final int STATUS_TYPE_EXT_FRAGE = 4;
    public static final int STATUS_TYPE_EXT_ANTWORT = 5;
    public static final int STATUS_TYPE_EXT_SCHALT = 6;
    public static final int STATUS_TYPE_EXT_FEHLER = 7;
    public static final int STATUS_DATASIZE_NONE = 0;
    public static final int STATUS_DATASIZE_1BIT = 1;
    public static final int STATUS_DATASIZE_2BIT = 2;
    public static final int STATUS_DATASIZE_3BIT = 3;
    public static final int STATUS_DATASIZE_4BIT = 4;
    public static final int STATUS_DATASIZE_1BYTE = 5;
    public static final int STATUS_DATASIZE_2BYTE = 6;
    public static final int STATUS_DATASIZE_3BYTE = 7;
    public static final int STATUS_DATASIZE_4BYTE = 8;
    public static final int STATUS_DATASIZE_5BYTE = 9;
    public static final int STATUS_DATASIZE_6BYTE = 10;
    public static final int STATUS_DATASIZE_7BYTE = 11;
    public static final int STATUS_DATASIZE_8BYTE = 12;
    public static final int STATUS_DATASIZE_10BYTE = 13;
    public static final int STATUS_DATASIZE_12BYTE = 14;
    public static final int STATUS_DATASIZE_16BYTE = 15;
    public static final int[] BMX_DATASIZE_LENGTH = new int[]{0, 1, 1, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 16};
    public static final byte TRACE_LISTE_FILTERED_MODUS_OLDEST = 0;
    public static final byte TRACE_LISTE_FILTERED_MODUS_NEWEST = 1;
    public static final byte TRACE_LISTE_FILTERED_MODUS_AFTER = 2;
    public static final byte TRACE_LISTE_FILTERED_MODUS_BEFORE = 3;
    public static final byte TRACE_LISTE_FILTERED_MODUS_BETWEEN = 4;
    public static final byte TRACE_LISTE_FILTERED_ADDR_WILDCARD = 0;
    public static final byte TRACE_LISTE_FILTERED_ADDR_GRP = 1;
    public static final byte TRACE_LISTE_FILTERED_ADDR_PHYS = 2;
    public static final byte TRACE_LISTE_FILTERED_ADDR_GRP_AND_PHYS = 3;
    public static final byte TRACE_LISTE_FILTERED_ADDR_GRP_OR_PHYS = 4;
    public static final byte TRACE_LISTE_FILTERED_ADDR_GRP_NAND_PHYS = 5;
    public static final byte TRACE_LISTE_FILTERED_ADDR_GRP_NOR_PHYS = 6;
    public static final byte TRACE_LISTE_FILTERED_ADDR_GRP_XOR_PHYS = 7;
    public static final int BMX_AstroCalcSunHeigth = 1;
    public static final int BMX_AstroCalcSunTimes = 2;
    public static final int BMX_AstroFunction_Success = 16;
    public static final int BMX_AstroFunction_Invalid = 17;
    public static final int BMX_AstroFunction_OutOfRange = 18;

    public static byte[] constructAuthPacket(int n, String string) {
        byte[] byArray = string.getBytes(Charset.forName("ISO-8859-1"));
        byte[] byArray2 = new byte[5 + byArray.length];
        int n2 = 0;
        byArray2[n2++] = (byte)byArray2.length;
        byArray2[n2++] = 0;
        byArray2[n2++] = -126;
        byArray2[n2++] = 0;
        byArray2[n2++] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        return byArray2;
    }

    public static byte[] constructOnlinePacket(String string) {
        byte[] byArray = new byte[9 + string.length()];
        byArray[0] = (byte)byArray.length;
        byArray[1] = 0;
        byArray[2] = 1;
        byArray[3] = 0;
        byArray[4] = 1;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        byArray[byArray.length - 1] = 0;
        return byArray;
    }

    public static byte[] constructOfflinePacket() {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 2, 0};
        return byArray;
    }

    public static byte[] constructDisconnectPacket() {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 2, 0};
        return byArray;
    }

    public static byte[] constructGetSystem(int n, String string) {
        byte[] byArray = new byte[9 + string.length()];
        byArray[0] = (byte)byArray.length;
        byArray[1] = 0;
        byArray[2] = 30;
        byArray[3] = 0;
        byArray[4] = (byte)n;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        ByteConv.string2byte(string, string.length() + 1, byArray, 8);
        return byArray;
    }

    public static byte[] constructSetSystem(int n, String string) {
        byte[] byArray = new byte[9 + string.length()];
        byArray[0] = (byte)byArray.length;
        byArray[1] = 0;
        byArray[2] = 31;
        byArray[3] = 0;
        byArray[4] = (byte)n;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        return byArray;
    }

    public static byte[] buildConfig(int n) {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 53, 0, 2, 0, (byte)n, 0};
        return byArray;
    }

    public static byte[] constructPongPacket() {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 11, 0};
        return byArray;
    }

    public static byte[] constructPingPacket() {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 10, 0};
        return byArray;
    }

    public static byte[] constructBMXIdentification(int n, String string) {
        byte[] byArray = new byte[8 + string.length() + 1];
        byArray[0] = (byte)byArray.length;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = (byte)n;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        byArray[byArray.length - 1] = 0;
        return byArray;
    }

    public static byte[] constructTelegram(int n, byte[] byArray, byte[] byArray2) {
        if (n == -1) {
            return null;
        }
        byte[] byArray3 = new byte[34];
        byArray3[0] = (byte)byArray3.length;
        byArray3[1] = 0;
        byArray3[2] = 4;
        byArray3[3] = 0;
        byArray3[4] = (byte)(n & 0xFF);
        byArray3[5] = (byte)((n & 0xFF00) >> 8);
        byArray3[8] = 0;
        byArray3[9] = 0;
        byArray3[10] = 0;
        byArray3[11] = 0;
        byArray3[12] = 0;
        byArray3[13] = 0;
        byArray3[14] = 0;
        byArray3[15] = 0;
        byArray3[16] = byArray[0];
        byArray3[17] = byArray[1];
        System.arraycopy(byArray2, 0, byArray3, 18, byArray2.length);
        return byArray3;
    }

    public static byte[] constructTelegram(int n, int n2, int n3, byte[] byArray) {
        return BMXPackets.constructTelegram(n, false, false, n2, n3, byArray);
    }

    public static byte[] constructTelegram(int n, boolean bl, boolean bl2, int n2, int n3, byte[] byArray) {
        byte[] byArray2 = new byte[2];
        if (bl) {
            byArray2[1] = (byte)(byArray2[1] | 0x40);
        }
        if (bl2) {
            byArray2[0] = (byte)(byArray2[0] | 0x80);
        }
        byArray2[0] = (byte)(byArray2[0] | (n2 & 7) << 4);
        byArray2[0] = (byte)(byArray2[0] | n3 & 0xF);
        return BMXPackets.constructTelegram(n, byArray2, byArray);
    }

    public static byte[] constructGetTeleTabelle() {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 6, 0};
        return byArray;
    }

    public static byte[] constructAutoPossibility() {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 100, 0, 0, 0, 0, 0, 0};
        return byArray;
    }

    public static byte[] constructAutoListe() {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 101, 0};
        return byArray;
    }

    public static byte[] constructGetAutoItem(BMXBasicJobData bMXBasicJobData) {
        byte[] byArray = null;
        byte[] byArray2 = bMXBasicJobData.getNameBytes();
        byArray = new byte[9 + byArray2.length];
        byArray[0] = (byte)byArray.length;
        byArray[1] = 0;
        byArray[2] = 102;
        byArray[3] = 0;
        System.arraycopy(bMXBasicJobData.getLibID().getLibID(), 0, byArray, 4, 4);
        System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
        byArray[byArray.length - 1] = 0;
        return byArray;
    }

    public static byte[] constructStoreAutoItem(BMXJobData bMXJobData) {
        byte[] byArray = bMXJobData.getDataPackage();
        byte[] byArray2 = new byte[4 + byArray.length];
        byArray2[0] = (byte)(byArray2.length & 0xFF);
        byArray2[1] = (byte)((byArray2.length & 0xFF00) >> 8);
        byArray2[2] = 103;
        byArray2[3] = 0;
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        return byArray2;
    }

    public static byte[] constructAddAutoItem(BMXJobData bMXJobData) {
        byte[] byArray = bMXJobData.getDataPackage();
        byte[] byArray2 = new byte[4 + byArray.length];
        byArray2[0] = (byte)(byArray2.length & 0xFF);
        byArray2[1] = (byte)((byArray2.length & 0xFF00) >> 8);
        byArray2[2] = 104;
        byArray2[3] = 0;
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        return byArray2;
    }

    public static byte[] constructDeleteAutoItem(BMXBasicJobData bMXBasicJobData) {
        byte[] byArray = bMXBasicJobData.getNameBytes();
        byte[] byArray2 = new byte[9 + byArray.length];
        byArray2[0] = (byte)byArray2.length;
        byArray2[1] = 0;
        byArray2[2] = 105;
        byArray2[3] = 0;
        System.arraycopy(bMXBasicJobData.getLibID().getLibID(), 0, byArray2, 4, 4);
        System.arraycopy(byArray, 0, byArray2, 8, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    public static byte[] constructTraceListeFiltered(short s, byte by, byte by2, byte by3, short s2, int[] nArray, int n, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[38];
        byArray3[0] = (byte)byArray3.length;
        byArray3[1] = 0;
        byArray3[2] = 124;
        byArray3[3] = 0;
        byArray3[4] = (byte)(s & 0xFF);
        byArray3[5] = (byte)((s & 0xFF00) >> 8);
        byArray3[6] = (byte)(by | by2 << 4);
        byArray3[7] = by3;
        byArray3[8] = (byte)(s2 & 0xFF);
        byArray3[9] = (byte)((s2 & 0xFF00) >> 8);
        for (int i = 0; i < nArray.length; ++i) {
            byArray3[10 + i * 2] = (byte)(nArray[i] & 0xFF);
            byArray3[11 + i * 2] = (byte)((nArray[i] & 0xFF00) >> 8);
        }
        byArray3[20] = (byte)(n & 0xFF);
        byArray3[21] = (byte)((n & 0xFF00) >> 8);
        if (byArray != null && byArray.length == 8) {
            System.arraycopy(byArray, 0, byArray3, 22, 8);
        }
        if (byArray2 != null && byArray2.length == 8) {
            System.arraycopy(byArray2, 0, byArray3, 30, 8);
        }
        return byArray3;
    }

    public static byte[] constructTraceListe() {
        byte[] byArray = new byte[38];
        byArray[0] = (byte)byArray.length;
        byArray[1] = 0;
        byArray[2] = 43;
        byArray[3] = 0;
        return byArray;
    }

    public static byte[] constructBMXCrypto(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[272];
        byArray2[0] = (byte)(byArray2.length & 0xFF);
        byArray2[1] = (byte)((byArray2.length & 0xFF00) >> 8);
        byArray2[2] = 123;
        byArray2[3] = 0;
        byArray2[4] = 2;
        byArray2[5] = 0;
        byArray2[6] = 0;
        byArray2[7] = 0;
        byArray2[8] = (byte)n;
        byArray2[9] = 0;
        byArray2[10] = 0;
        byArray2[11] = 0;
        byArray2[12] = (byte)(n2 & 0xFF);
        byArray2[13] = (byte)(n2 >> 8 & 0xFF);
        byArray2[14] = 0;
        byArray2[15] = 0;
        byte[] byArray3 = new byte[256];
        Random random = new Random();
        random.nextBytes(byArray3);
        byArray3[75] = byArray[0];
        byArray3[64] = byArray[1];
        byArray3[42] = byArray[2];
        byArray3[7] = byArray[3];
        byArray3[40] = byArray[4];
        byArray3[187] = byArray[5];
        byArray3[249] = byArray[6];
        byArray3[101] = byArray[7];
        System.arraycopy(byArray3, 0, byArray2, 16, 256);
        return byArray2;
    }

    public static byte[] constructRapData(int n) {
        byte[] byArray;
        byArray = new byte[]{(byte)byArray.length, 0, 125, 0, (byte)n, 0, 0, 0, 0};
        return byArray;
    }

    public static byte[] constructAstroGetHeight(short s, float f, float f2, String string, byte by, byte by2, byte by3) {
        byte[] byArray = new byte[86];
        int n = 0;
        byArray[n++] = (byte)byArray.length;
        byArray[n++] = 0;
        byArray[n++] = 126;
        byArray[n++] = 0;
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        ByteConv.short2byte(byArray, n, s);
        ByteConv.float2byte(byArray, n += 2, f);
        ByteConv.float2byte(byArray, n += 4, f2);
        ByteConv.string2byte(string, 64, byArray, n += 4);
        n += 64;
        byArray[n++] = by;
        byArray[n++] = by2;
        byArray[n++] = by3;
        return byArray;
    }

    public static byte[] constructAstroGetTimes(short s, float f, float f2, String string, byte by, short s2) {
        byte[] byArray = new byte[86];
        int n = 0;
        byArray[n++] = (byte)byArray.length;
        byArray[n++] = 0;
        byArray[n++] = 126;
        byArray[n++] = 0;
        byArray[n++] = 2;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        ByteConv.short2byte(byArray, n, s);
        ByteConv.float2byte(byArray, n += 2, f);
        ByteConv.float2byte(byArray, n += 4, f2);
        ByteConv.string2byte(string, 64, byArray, n += 4);
        n += 64;
        byArray[n++] = by;
        ByteConv.short2byte(byArray, n, s2);
        n += 2;
        return byArray;
    }

    public static byte[] constructEnOcean(int n, byte[] byArray) {
        byte[] byArray2 = new byte[6 + byArray.length];
        byArray2[0] = (byte)byArray2.length;
        byArray2[2] = -127;
        byArray2[4] = (byte)(n & 0xFF);
        byArray2[5] = (byte)(n >> 8 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 6, byArray.length);
        return byArray2;
    }

    public static byte[] constructEnOceanData(boolean bl, byte[] byArray, byte[] byArray2, byte[] byArray3, byte by) {
        byte[] byArray4 = new byte[18];
        byArray4[0] = (byte)byArray4.length;
        byArray4[2] = -127;
        byArray4[4] = 2;
        byArray4[6] = byArray[3];
        byArray4[7] = byArray[2];
        byArray4[8] = byArray[1];
        byArray4[9] = byArray[0];
        byArray4[10] = byArray2[0];
        byArray4[11] = byArray2[1];
        byArray4[12] = byArray2[2];
        byArray4[13] = byArray3[0];
        byArray4[14] = byArray3[1];
        byArray4[15] = byArray3[2];
        byArray4[16] = byArray3[3];
        byArray4[17] = by;
        return byArray4;
    }

    public static byte[] doubleToByteArray(double d) {
        long l = Double.doubleToLongBits(d);
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
        return byArray;
    }
}

