/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.deprecated.eibaddress;

import de.babtec.globals.deprecated.eibaddress.Address;
import de.babtec.globals.deprecated.eibaddress.IllegalAddressException;
import de.babtec.globals.knx.address.EIBAddressFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class AddressObject {
    private static final int MAX_ADDRESSES = 5;
    public static final int TYPE_ADDRESSOBJECT = 0;
    public static final int TYPE_ADDRESS = 1;
    private ArrayList<Address> addresses = new ArrayList();
    private int type = 0;

    public AddressObject(String string, int n) throws IllegalAddressException {
        this.type = n;
        this.parseString(string);
    }

    public AddressObject(String string) throws IllegalAddressException {
        this.type = 0;
        this.parseString(string);
    }

    public static boolean addressIsValid(String string) {
        return Pattern.matches("\\A(\\d{1,2}\\/\\d{1,4}(\\((\\d{1,2}\\/\\d{1,4},){0,3}\\d{1,2}\\/\\d{1,4}\\)){0,1}){0,1}\\Z", string) || Pattern.matches("\\A\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}(\\((\\d{1,2}\\/\\d{1,2}\\/\\d{1,3},){0,3}\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}\\)){0,1}\\Z", string);
    }

    public static boolean addressIsNotEmpty(String string) {
        return !string.trim().equals("") && AddressObject.addressIsValid(string);
    }

    private void parseString(String string) throws IllegalAddressException {
        boolean bl = Pattern.matches("\\A(\\d{1,2}\\/\\d{1,4}(\\((\\d{1,2}\\/\\d{1,4},){0,3}\\d{1,2}\\/\\d{1,4}\\)){0,1}){0,1}\\Z", string);
        boolean bl2 = Pattern.matches("\\A\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}(\\((\\d{1,2}\\/\\d{1,2}\\/\\d{1,3},){0,3}\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}\\)){0,1}\\Z", string);
        if (!bl && !bl2) {
            throw new IllegalAddressException("Illegal EIB-Address format!");
        }
        if (string.endsWith(")")) {
            string = string.replace('(', ',');
            string = string.substring(0, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            this.addAddress(new Address(stringTokenizer.nextToken()));
        }
    }

    public int getMaxSize() {
        if (this.type == 0) {
            return 5;
        }
        return 1;
    }

    public AddressObject(byte[] byArray) {
        int n;
        if (byArray.length < 10) {
            throw new IllegalArgumentException("The input-array is no valid AddressObject (size < 10)");
        }
        for (int i = 0; i < 5 && (n = (byArray[i * 2 + 1] & 0xFF) << 8 | byArray[i * 2] & 0xFF) != 0; ++i) {
            this.addAddress(new Address(n));
        }
    }

    public boolean addAddress(Address address) {
        if (this.addresses.size() < this.getMaxSize()) {
            this.addresses.add(address);
            return true;
        }
        return false;
    }

    public String getString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.addresses.size() > 0) {
            stringBuffer.append(this.addresses.get(0).getString(n));
            if (this.addresses.size() > 1) {
                stringBuffer.append("(");
                for (int i = 1; i < this.addresses.size(); ++i) {
                    if (i > 1) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.addresses.get(i).getString(n));
                }
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public String getAddressString() {
        if (this.addresses.size() == 0) {
            return "";
        }
        return this.getString(EIBAddressFormat.getAddressFormat());
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[12];
        for (int i = 0; i < this.addresses.size(); ++i) {
            int n = this.addresses.get(i).getIntAddress();
            byArray[i * 2 + 1] = (byte)((n & 0xFF00) >> 8);
            byArray[i * 2] = (byte)(n & 0xFF);
        }
        return byArray;
    }

    public String toString() {
        return "2 Layer: " + this.getString(2) + "\n" + "3 Layer: " + this.getString(3);
    }

    public int getCurrentSize() {
        return this.addresses.size();
    }

    public Address getAddress(int n) {
        if (n > this.addresses.size() - 1) {
            return null;
        }
        return this.addresses.get(n);
    }

    public boolean removeAddress(int n) {
        if (this.addresses.size() > 0) {
            this.addresses.remove(n);
            return true;
        }
        return false;
    }

    public void makeAddressMaster(int n) {
        Address address = this.addresses.remove(n);
        this.addresses.add(0, address);
    }
}

