/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata;

import de.babtec.globals.deprecated.eibaddress.AddressObject;
import de.babtec.globals.deprecated.eibaddress.IllegalAddressException;
import de.babtec.globals.jobdata.BMXBasicJobData;
import de.babtec.globals.jobdata.LibID;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class BMXJobData
extends BMXBasicJobData {
    private byte[] param;
    private ArrayList<EIBAddressObject2> addressObjects = new ArrayList();

    public BMXJobData(LibID libID, String string, boolean bl, byte[] byArray) {
        super(libID, string.trim(), bl);
        this.param = byArray;
    }

    public BMXJobData(byte[] byArray) {
        if (byArray.length == 0) {
            this.libID = new LibID(0, 0, 0);
        } else {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 2, byArray2, 0, 4);
            this.libID = new LibID(byArray2);
            int n = 0;
            byte[] byArray3 = new byte[16];
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 6; i < 22; ++i) {
                if (byArray[i] == 0) continue;
                byArray3[n++] = byArray[i];
                stringBuffer.append((char)(byArray[i] & 0xFF));
            }
            this.nameIsUTF8 = ByteConv.isUTF8(byArray3);
            try {
                this.setName(new String(byArray3, 0, n, this.nameIsUTF8 ? "UTF-8" : "ISO-8859-15"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                this.setName(new String(byArray3, 0, n));
            }
            int n2 = (byArray[23] & 0xFF) << 8 | byArray[22] & 0xFF;
            this.param = new byte[n2];
            System.arraycopy(byArray, 24, this.param, 0, n2);
            int n3 = (byArray[25 + n2] & 0xFF) << 8 | byArray[24 + n2] & 0xFF;
            int n4 = n3 / 28;
            for (int i = 0; i < n4; ++i) {
                int n5 = 26 + n2 + i * 28;
                int[] nArray = new int[5];
                for (int j = 0; j < 5; ++j) {
                    nArray[j] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8;
                }
                this.addressObjects.add(new EIBAddressObject2(nArray));
            }
        }
    }

    public byte[] getDataPackage() {
        int n = this.param.length;
        int n2 = this.addressObjects.size() * 28;
        byte[] byArray = new byte[26 + n + n2];
        byArray[0] = (byte)(byArray.length % 256);
        byArray[1] = (byte)Math.floor(byArray.length / 256);
        System.arraycopy(this.libID.getLibID(), 0, byArray, 2, 4);
        System.arraycopy(this.getNameBytes(), 0, byArray, 6, this.getNameBytes().length);
        byArray[22] = (byte)(n % 256);
        byArray[23] = (byte)Math.floor(n / 256);
        System.arraycopy(this.param, 0, byArray, 24, n);
        byArray[24 + n] = (byte)(n2 % 256);
        byArray[25 + n] = (byte)Math.floor(n2 / 256);
        for (int i = 0; i < this.addressObjects.size(); ++i) {
            int[] nArray;
            int n3 = 26 + n + i * 28;
            EIBAddressObject2 eIBAddressObject2 = this.addressObjects.get(i);
            for (int n4 : nArray = eIBAddressObject2 != null ? eIBAddressObject2.getAddressObjectAsInteger() : new int[]{}) {
                byArray[n3++] = (byte)(n4 & 0xFF);
                byArray[n3++] = (byte)((n4 & 0xFF00) >> 8);
            }
        }
        return byArray;
    }

    public int getAddressObjectCount() {
        return this.addressObjects.size();
    }

    public EIBAddressObject2 getEIBAddressObject2(int n) {
        return this.addressObjects.get(n);
    }

    public void addEIBAddressObject2(EIBAddressObject2 eIBAddressObject2) {
        this.addressObjects.add(eIBAddressObject2);
    }

    @Deprecated
    public AddressObject getAddressObject(int n) {
        if (n >= this.addressObjects.size()) {
            return null;
        }
        try {
            return new AddressObject(this.addressObjects.get(n).getAddressObjectAsString());
        }
        catch (IllegalAddressException illegalAddressException) {
            return null;
        }
    }

    @Deprecated
    public void addAddressObject(AddressObject addressObject) {
        this.addressObjects.add(new EIBAddressObject2(addressObject.getAddressString()));
    }

    public void addAddressObjectDummy() {
        this.addressObjects.add(new EIBAddressObject2(new int[0]));
    }

    public byte[] getParam() {
        return this.param;
    }
}

