/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.Scene;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.knx.datatype.DataType;

public class BMXScene
extends BMXJobModel {
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objStart;
    private EIBAddressObject2 objSave;
    private ValueObject[] valueObject = new ValueObject[28];
    private int flags;
    private int startValue;
    private boolean stoppable;
    private int saveValue;
    private int delay;
    private int outputs;

    public BMXScene(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXScene() {
        for (int i = 0; i < this.valueObject.length; ++i) {
            this.valueObject[i] = new ValueObject();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        this.outputs = byArray[6] & 0xFF;
        for (int i = 0; i < this.outputs; ++i) {
            this.valueObject[i] = new ValueObject();
            this.valueObject[i].ga = bMXJobData.getEIBAddressObject2(i + 3);
            this.valueObject[i].dt = DataType.getBMXDataType(byArray[7 + i * 10]);
            byte[] byArray2 = new byte[8];
            System.arraycopy(byArray, 9 + i * 10, byArray2, 0, 8);
            this.valueObject[i].value = this.valueObject[i].dt.getDoubleValue(byArray2, 1.0, 0.0);
        }
        this.flags = byArray[0];
        this.startValue = this.flags & 1;
        this.stoppable = (this.flags & 2) != 0;
        this.saveValue = (this.flags & 4) >> 2;
        this.delay = (byArray[2] & 0xFF) << 8 | byArray[1] & 0xFF;
        this.objEnable = bMXJobData.getEIBAddressObject2(0);
        this.objStart = bMXJobData.getEIBAddressObject2(1);
        this.objSave = bMXJobData.getEIBAddressObject2(2);
    }

    @Override
    public BMXJobData getJobData() {
        byte[] byArray = new byte[287];
        byArray[0] = (byte)(byArray[0] | this.startValue & 1);
        byArray[0] = (byte)(byArray[0] | (this.stoppable ? 2 : 0));
        byArray[0] = (byte)(byArray[0] | (this.saveValue & 1) << 2);
        byArray[1] = (byte)(this.delay & 0xFF);
        byArray[2] = (byte)((this.delay & 0xFF00) >> 8);
        byArray[6] = (byte)this.outputs;
        for (int i = 0; i < this.outputs; ++i) {
            byArray[7 + i * 10] = this.valueObject[i].dt.getBmxIndex();
            Object t = this.valueObject[i].dt.getDataValue(this.valueObject[i].value);
            byte[] byArray2 = this.valueObject[i].dt.getData(t);
            System.arraycopy(byArray2, 0, byArray, 9 + i * 10, byArray2.length);
        }
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_SCENE, byArray);
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objStart);
        bMXJobData.addEIBAddressObject2(this.objSave);
        for (int i = 0; i < this.outputs; ++i) {
            bMXJobData.addEIBAddressObject2(this.valueObject[i].ga);
        }
        return bMXJobData;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStart() {
        return this.objStart;
    }

    public void setObjStart(EIBAddressObject2 eIBAddressObject2) {
        this.objStart = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjSave() {
        return this.objSave;
    }

    public void setObjSave(EIBAddressObject2 eIBAddressObject2) {
        this.objSave = eIBAddressObject2;
    }

    public int getStartValue() {
        return this.startValue;
    }

    public void setStartValue(int n) {
        this.startValue = n;
    }

    public int getSaveValue() {
        return this.saveValue;
    }

    public void setSaveValue(int n) {
        this.saveValue = n;
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public void setStoppable(boolean bl) {
        this.stoppable = bl;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public int getOutputCount() {
        return this.outputs;
    }

    public void setOutputCount(int n) {
        this.outputs = n;
    }

    public EIBAddressObject2 getOutputGA(int n) {
        return this.valueObject[n].ga;
    }

    public void setOutputGA(int n, EIBAddressObject2 eIBAddressObject2) {
        this.valueObject[n].ga = eIBAddressObject2;
    }

    public DataType<?> getOutputDataType(int n) {
        return this.valueObject[n].dt;
    }

    public void setOutputDataType(int n, DataType<?> dataType) {
        this.valueObject[n].dt = dataType;
    }

    public double getOutputValue(int n) {
        return this.valueObject[n].value;
    }

    public void setOutputValue(int n, double d) {
        this.valueObject[n].value = d;
    }

    class ValueObject {
        EIBAddressObject2 ga;
        DataType dt;
        double value;

        ValueObject() {
        }
    }
}

