/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.astrotimer;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.astrotimer.OutputPointInTime;
import de.babtec.globals.jobdata.jobs.astrotimer.PointInTime;
import de.babtec.globals.knx.address.EIBAddress2;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.util.ArrayList;

public class BMXAstroTimerModel
extends BMXJobModel {
    public static final int JOBS_ATIMER_OUTPUTS = 48;
    public static final int JOBS_ATIMER_MAX_PIT = 8;
    public static final byte JOBS_ATIMER_PIT_SELECT_INACTIVE = -1;
    public static final int JOBS_ATIMER_OBMAX = 50;
    public static final int JOBS_ATIMER_DESCR_LEN = 15;
    public static final int JOBS_ATIMER_MAX_DATA_LEN = 16;
    public static final int JOBS_ATIMER_TZ_LEN = 64;
    public static final int JOBS_ATIMER_FLAGS_USE_EP_POS = 1;
    public static final int JOBS_ATIMER_FLAGS_USE_EP_TZONE = 2;
    public static final int JOBS_ATIMER_FLAGS_CONFIG_SIMPLE = 4;
    public static final int JOBS_ATIMER_FLAGS_ALL = 3;
    public static final byte JOBS_ATIMER_PIT_SRC_UNKNOWN = 0;
    public static final byte JOBS_ATIMER_PIT_SRC_SUNRISE = 1;
    public static final byte JOBS_ATIMER_PIT_SRC_SUNSET = 2;
    public static final byte JOBS_ATIMER_PIT_SRC_SUNCLIMAX = 3;
    public static final byte JOBS_ATIMER_PIT_SRC_FIXED = 4;
    public static final int JOBS_ATIMER_PIT_FLAGS_CLIP_EARLIEST = 1;
    public static final int JOBS_ATIMER_PIT_FLAGS_CLIP_LATEST = 2;
    public static final byte JOBS_ATIMER_OUTPUT_PIT_FLAGS_EXTRA1 = 1;
    public static final byte JOBS_ATIMER_OUTPUT_PIT_FLAGS_EXTRA2 = 2;
    public static final byte JOBS_ATIMER_OUTPUT_PIT_FLAGS_EXTRA3 = 4;
    public static final byte JOBS_ATIMER_OUTPUT_PIT_FLAGS_DAYOFWEEK = 8;
    public static final byte JOBS_ATIMER_OUTPUT_PIT_FLAGS_DONE = -128;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objPitSelect;
    private byte flags;
    private float longitude;
    private float latitude;
    private String timezone;
    private PointInTime[] pit = new PointInTime[8];
    private ArrayList<OutputPointInTime> opit = new ArrayList();

    public BMXAstroTimerModel(BMXJobData bMXJobData) {
        for (int i = 0; i < this.pit.length; ++i) {
            this.pit[i] = new PointInTime();
        }
        this.setBMXJobData(bMXJobData);
    }

    public BMXAstroTimerModel(boolean bl, String string) {
        for (int i = 0; i < this.pit.length; ++i) {
            this.pit[i] = new PointInTime();
            this.pit[i].setDescription(string + "#" + i);
            this.pit[i].setSrc((byte)1);
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.flags = byArray[n2++];
        this.longitude = ByteConv.byte2float(byArray, n2);
        this.latitude = ByteConv.byte2float(byArray, n2 += 4);
        this.timezone = ByteConv.byte2string(byArray, n2 += 4, 64);
        n2 += 64;
        for (n = 0; n < 8; ++n) {
            this.pit[n].setSrc(byArray[n2++]);
            this.pit[n].setFlags(byArray[n2++]);
            this.pit[n].setDescription(ByteConv.byte2string(byArray, n2, 16));
            n2 += 16;
            this.pit[n].setFixed_hour(byArray[n2++]);
            this.pit[n].setFixed_min(byArray[n2++]);
            this.pit[n].setHeight((short)ByteConv.byte2short(byArray, n2));
            this.pit[n].setStatic_offset((short)ByteConv.byte2short(byArray, n2 += 2));
            this.pit[n].setRandom_offset(ByteConv.byte2short(byArray, n2 += 2));
            n2 += 2;
            this.pit[n].setEarliest_hour(byArray[n2++]);
            this.pit[n].setEarliest_min(byArray[n2++]);
            this.pit[n].setLatest_hour(byArray[n2++]);
            this.pit[n].setLatest_min(byArray[n2++]);
            this.pit[n].setOutputRaw(EIBAddress2.getAddress(ByteConv.byte2short(byArray, n2)));
            this.pit[n].setOutput(EIBAddress2.getAddress(ByteConv.byte2short(byArray, n2 += 2)));
            this.pit[n].setElevation(ByteConv.byte2float(byArray, n2 += 2));
            this.pit[n].setAzimuth(ByteConv.byte2float(byArray, n2 += 4));
            n2 += 4;
        }
        for (n = 0; n < 16; ++n) {
            OutputPointInTime outputPointInTime = new OutputPointInTime();
            outputPointInTime.setFlags(byArray[n2++]);
            outputPointInTime.setPit_weekdays(byArray[n2++]);
            outputPointInTime.setPit_saturday(byArray[n2++]);
            outputPointInTime.setPit_sunday(byArray[n2++]);
            outputPointInTime.setExtra_val1(byArray[n2++]);
            outputPointInTime.setPit_extra1(byArray[n2++]);
            outputPointInTime.setExtra_val2(byArray[n2++]);
            outputPointInTime.setPit_extra2(byArray[n2++]);
            outputPointInTime.setExtra_val3(byArray[n2++]);
            outputPointInTime.setPit_extra3(byArray[n2++]);
            outputPointInTime.setOutput(EIBAddress2.getAddress(ByteConv.byte2short(byArray, n2)));
            n2 += 2;
            outputPointInTime.setEis(byArray[n2++]);
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, n2, byArray2, 0, 16);
            outputPointInTime.setData(byArray2);
            n2 += 16;
            if (outputPointInTime.getOutput() == null) continue;
            this.opit.add(outputPointInTime);
        }
        this.objEnable = bMXJobData.getEIBAddressObject2(0);
        this.objPitSelect = bMXJobData.getEIBAddressObject2(1);
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        byte[] byArray = new byte[1801];
        int n2 = 0;
        byArray[n2++] = this.flags;
        ByteConv.float2byte(byArray, n2, this.longitude);
        ByteConv.float2byte(byArray, n2 += 4, this.latitude);
        ByteConv.string2byte(this.timezone, 64, byArray, n2 += 4);
        n2 += 64;
        for (n = 0; n < 8; ++n) {
            byArray[n2++] = this.pit[n].getSrc();
            byArray[n2++] = this.pit[n].getFlags();
            ByteConv.string2byte(this.pit[n].getDescription(), 16, byArray, n2);
            n2 += 16;
            byArray[n2++] = this.pit[n].getFixed_hour();
            byArray[n2++] = this.pit[n].getFixed_min();
            ByteConv.short2byte(byArray, n2, this.pit[n].getHeight());
            ByteConv.short2byte(byArray, n2 += 2, this.pit[n].getStatic_offset());
            ByteConv.short2byte(byArray, n2 += 2, this.pit[n].getRandom_offset());
            n2 += 2;
            byArray[n2++] = this.pit[n].getEarliest_hour();
            byArray[n2++] = this.pit[n].getEarliest_min();
            byArray[n2++] = this.pit[n].getLatest_hour();
            byArray[n2++] = this.pit[n].getLatest_min();
            if (this.pit[n].getOutputRaw() != null) {
                ByteConv.short2byte(byArray, n2, this.pit[n].getOutputRaw().getIntAddress());
            }
            n2 += 2;
            if (this.pit[n].getOutput() != null) {
                ByteConv.short2byte(byArray, n2, this.pit[n].getOutput().getIntAddress());
            }
            ByteConv.float2byte(byArray, n2 += 2, this.pit[n].getElevation());
            ByteConv.float2byte(byArray, n2 += 4, this.pit[n].getAzimuth());
            n2 += 4;
        }
        for (n = 0; n < this.opit.size(); ++n) {
            byArray[n2++] = this.opit.get(n).getFlags();
            byArray[n2++] = this.opit.get(n).getPit_weekdays();
            byArray[n2++] = this.opit.get(n).getPit_saturday();
            byArray[n2++] = this.opit.get(n).getPit_sunday();
            byArray[n2++] = this.opit.get(n).getExtra_val1();
            byArray[n2++] = this.opit.get(n).getPit_extra1();
            byArray[n2++] = this.opit.get(n).getExtra_val2();
            byArray[n2++] = this.opit.get(n).getPit_extra2();
            byArray[n2++] = this.opit.get(n).getExtra_val3();
            byArray[n2++] = this.opit.get(n).getPit_extra3();
            if (this.opit.get(n).getOutput() != null) {
                ByteConv.short2byte(byArray, n2, this.opit.get(n).getOutput().getIntAddress());
            }
            n2 += 2;
            byArray[n2++] = this.opit.get(n).getEis();
            System.arraycopy(this.opit.get(n).getData(), 0, byArray, n2, Math.min(this.opit.get(n).getData().length, 16));
            n2 += 16;
        }
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_ASTROTIMER, byArray);
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objPitSelect);
        return bMXJobData;
    }

    @Override
    public String toString() {
        int n;
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string);
        stringBuffer.append("Object Enable: " + this.objEnable.getAddressObjectAsString() + string);
        stringBuffer.append("Object PIT Select: " + this.objPitSelect.getAddressObjectAsString() + string);
        stringBuffer.append("Latitude: " + this.latitude + string);
        stringBuffer.append("Longitude: " + this.longitude + string);
        stringBuffer.append("Timezone: " + this.timezone + string);
        stringBuffer.append("===========================" + string);
        for (n = 0; n < 8; ++n) {
            stringBuffer.append("PIT #" + n + string);
            stringBuffer.append(this.pit[n].getDescription() + string);
        }
        stringBuffer.append("===========================" + string);
        for (n = 0; n < this.opit.size(); ++n) {
            stringBuffer.append("OPIT #" + n + "(" + this.opit.get(n).getOutput() + ")" + string);
        }
        return stringBuffer.toString();
    }

    public boolean getConfigurationSimple() {
        return (this.flags & 4) != 0;
    }

    public void setConfigurationSimple(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjPitSelect() {
        return this.objPitSelect;
    }

    public void setObjPitSelect(EIBAddressObject2 eIBAddressObject2) {
        this.objPitSelect = eIBAddressObject2;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public void setUseEpLocation(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean getUseEpLocation() {
        return (this.flags & 1) > 0;
    }

    public void setUseEpTimezone(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public boolean getUseEpTimezone() {
        return (this.flags & 2) > 0;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(float f) {
        this.longitude = f;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(float f) {
        this.latitude = f;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String string) {
        this.timezone = string;
    }

    public PointInTime[] getPointInTime() {
        return this.pit;
    }

    public boolean addOutput(OutputPointInTime outputPointInTime) {
        if (this.opit.size() < 48) {
            this.opit.add(outputPointInTime);
            return true;
        }
        return false;
    }

    public void removeOutput(OutputPointInTime outputPointInTime) {
        this.opit.remove(outputPointInTime);
    }

    public void removeAllOutputs() {
        this.opit.clear();
    }

    public int getOutputCount() {
        return this.opit.size();
    }

    public OutputPointInTime getOutput(int n) {
        if (n >= this.opit.size()) {
            return null;
        }
        return this.opit.get(n);
    }

    public OutputPointInTime[] getOutputArray() {
        return this.opit.toArray(new OutputPointInTime[this.opit.size()]);
    }
}

