/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.counter;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.counter.CounterInput;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.knx.datatype.DataType;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXCounter
extends BMXJobModel {
    public static final int JOBS_COUNTER_INPUTS = 8;
    public static final int JOBS_COUNTER_OBMAX = 13;
    public static final int JOBS_COUNTER_FLAGS_OUTPUT_SATURATION = 1;
    public static final int JOBS_COUNTER_FLAGS_ALL = 1;
    public static final int JOBS_COUNTER_INPUT_TYPE_DISABLED = 0;
    public static final int JOBS_COUNTER_INPUT_TYPE_INCREMENT = 1;
    public static final int JOBS_COUNTER_INPUT_TYPE_DECREMENT = 2;
    public static final int JOBS_COUNTER_INPUT_TYPE_ADD_VALUE = 3;
    public static final int JOBS_COUNTER_INPUT_TYPE_SUB_VALUE = 4;
    public static final int JOBS_COUNTER_INPUT_TYPE_CLEAR = 5;
    public static final int JOBS_COUNTER_INPUT_TYPE_PRESET = 6;
    public static final int JOBS_COUNTER_INPUT_TYPE_PRESET_VALUE = 7;
    public static final int JOBS_COUNTER_INPUT_TYPE_MAX = 7;
    public static final int JOBS_COUNTER_INPUT_FLAGS_TERMINAL_INPUT = 1;
    private int flags;
    private CounterInput[] inputs = new CounterInput[8];
    private byte value_eis;
    private byte output_eis;
    private int preset;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objFunction;
    private EIBAddressObject2 objValue;
    private EIBAddressObject2 objPreset;
    private EIBAddressObject2[] objInput = new EIBAddressObject2[8];
    private EIBAddressObject2 objOutput;

    public BMXCounter(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXCounter() {
        for (int i = 0; i < 8; ++i) {
            this.inputs[i] = new CounterInput();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.flags = byArray[n2++];
        for (n = 0; n < 8; ++n) {
            this.inputs[n].setEis(byArray[n2++]);
            this.inputs[n].setType(byArray[n2++]);
            this.inputs[n].setPreset(ByteConv.byte2long(byArray, n2));
            n2 += 4;
            this.inputs[n].setFlags(byArray[n2++]);
        }
        this.value_eis = byArray[n2++];
        this.output_eis = byArray[n2++];
        this.preset = ByteConv.byte2long(byArray, n2);
        n2 += 4;
        n = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n++);
        this.objFunction = bMXJobData.getEIBAddressObject2(n++);
        this.objValue = bMXJobData.getEIBAddressObject2(n++);
        this.objPreset = bMXJobData.getEIBAddressObject2(n++);
        for (int i = 0; i < 8; ++i) {
            this.objInput[i] = bMXJobData.getEIBAddressObject2(n++);
        }
        this.objOutput = bMXJobData.getEIBAddressObject2(n++);
    }

    @Override
    public BMXJobData getJobData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.flags);
            for (int i = 0; i < 8; ++i) {
                byteArrayOutputStream.write(this.inputs[i].getEis());
                byteArrayOutputStream.write(this.inputs[i].getType());
                byteArrayOutputStream.write(ByteConv.long2byte(this.inputs[i].getPreset()));
                byteArrayOutputStream.write(this.inputs[i].getFlags());
            }
            byteArrayOutputStream.write(this.value_eis);
            byteArrayOutputStream.write(this.output_eis);
            byteArrayOutputStream.write(ByteConv.long2byte(this.preset));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_COUNTER, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objFunction);
        bMXJobData.addEIBAddressObject2(this.objValue);
        bMXJobData.addEIBAddressObject2(this.objPreset);
        for (int i = 0; i < 8; ++i) {
            bMXJobData.addEIBAddressObject2(this.objInput[i]);
        }
        bMXJobData.addEIBAddressObject2(this.objOutput);
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        string2 = string2 + "function: \t" + this.objFunction.getAddressObjectAsString() + "\n";
        string2 = string2 + "value: \t" + this.objValue.getAddressObjectAsString() + "\n";
        string2 = string2 + "value eis: \t" + DataType.getBMXDataType(this.value_eis).toString();
        string2 = string2 + "output: \t" + this.objOutput.getAddressObjectAsString() + "\n";
        string2 = string2 + "output eis: \t" + DataType.getBMXDataType(this.output_eis).toString();
        string2 = string2 + "preset: \t" + this.objPreset.getAddressObjectAsString() + "\n";
        for (int i = 0; i < 8; ++i) {
            if (this.objInput[i] == null) continue;
            string2 = string2 + "input " + i + ": \t" + this.objInput[i].getAddressObjectAsString() + "\n";
            string2 = string2 + "eis " + i + ": \t" + DataType.getBMXDataType(this.inputs[i].getEis()).toString();
            string2 = string2 + "type " + i + ": \t" + this.inputs[i].getPreset();
            string2 = string2 + "flags " + i + ": \t" + this.inputs[i].getFlags();
        }
        return string2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public CounterInput[] getCounterInputs() {
        return this.inputs;
    }

    public byte getOutputEis() {
        return this.output_eis;
    }

    public void setOutputEis(byte by) {
        this.output_eis = by;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjInput() {
        return this.objInput;
    }

    public void setObjInput(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objInput = eIBAddressObject2Array;
    }

    public EIBAddressObject2 getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objOutput = eIBAddressObject2;
    }
}

