/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.dalimonitor;

import com.google.gson.JsonObject;
import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.knx.datatype.DataType;
import de.babtec.globals.utils.ByteConv;
import java.nio.charset.Charset;

public class BMXDaliMonitor
extends BMXJobModel {
    public static final String JOBS_DALI_DEFAULT_TITLE_ENCODING = "UTF-8";
    public static final int JOBS_DALI_OUTPUTS = 64;
    public static final int JOBS_DALI_MAX_TITLE_LEN = 48;
    public static final int JOBS_DALIMON_RESERVED_VERSION1 = 128;
    public static final int JOBS_DALI_PARAM_LENGTH = 3214;
    public static final int JOBS_DALIMON_GW_TYPE_DGS11 = 1;
    public static final int JOBS_DALI_DELAY_STATUS_FEEDBACK = 1;
    private byte flags = 1;
    private byte version = 1;
    private int requestInterval = 3;
    private byte gwType = 1;
    private byte titleEncoding = 1;
    private String[] outTitle = new String[64];
    private long outAvailable = -1L;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objStartCheckAll;
    private EIBAddressObject2 objStartCheckOne;
    private EIBAddressObject2 objCurrentCheckIndex;
    private EIBAddressObject2 objResponseLamp;
    private EIBAddressObject2 objResponseBallast;
    private EIBAddressObject2 objStateLamp;
    private EIBAddressObject2 objStateBallast;
    private EIBAddressObject2 objDefectOut;

    public BMXDaliMonitor(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXDaliMonitor() {
        for (int i = 0; i < 64; ++i) {
            this.outTitle[i] = "#" + (i + 1) + ": ";
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.flags = byArray[n2++];
        this.version = byArray[n2++];
        this.requestInterval = ByteConv.byte2short(byArray, n2);
        n2 += 2;
        this.gwType = byArray[n2++];
        this.titleEncoding = byArray[n2++];
        byte[] byArray2 = new byte[48];
        for (int i = 0; i < 64; ++i) {
            n = 0;
            for (n = 0; n < 48 && byArray[n2 + n] != 0; ++n) {
                byArray2[n] = byArray[n2 + n];
            }
            this.outTitle[i] = new String(byArray2, 0, n, Charset.forName(JOBS_DALI_DEFAULT_TITLE_ENCODING));
            n2 += 48;
        }
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, n2 += 128, byArray3, 0, 8);
        this.outAvailable = DataType.getDpt29().getValue(byArray3);
        n2 += 8;
        n = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n++);
        this.objStartCheckAll = bMXJobData.getEIBAddressObject2(n++);
        this.objStartCheckOne = bMXJobData.getEIBAddressObject2(n++);
        this.objCurrentCheckIndex = bMXJobData.getEIBAddressObject2(n++);
        this.objResponseLamp = bMXJobData.getEIBAddressObject2(n++);
        this.objResponseBallast = bMXJobData.getEIBAddressObject2(n++);
        this.objStateLamp = bMXJobData.getEIBAddressObject2(n++);
        this.objStateBallast = bMXJobData.getEIBAddressObject2(n++);
        this.objDefectOut = bMXJobData.getEIBAddressObject2(n++);
    }

    @Override
    public BMXJobData getJobData() {
        byte[] byArray = new byte[3214];
        int n = 0;
        byArray[n++] = (byte)(this.flags & 0xFF);
        byArray[n++] = (byte)(this.version & 0xFF);
        ByteConv.short2byte(byArray, n, this.requestInterval);
        n += 2;
        byArray[n++] = (byte)(this.gwType & 0xFF);
        byArray[n++] = (byte)(this.titleEncoding & 0xFF);
        for (int i = 0; i < 64; ++i) {
            byte[] byArray2 = this.outTitle[i].getBytes(Charset.forName(JOBS_DALI_DEFAULT_TITLE_ENCODING));
            System.arraycopy(byArray2, 0, byArray, n, Math.min(byArray2.length, 48));
            n += 48;
        }
        byte[] byArray3 = DataType.getDpt29().getData(this.outAvailable);
        System.arraycopy(byArray3, 0, byArray, n += 128, 8);
        n += 8;
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_DALI_MONITOR, byArray);
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objStartCheckAll);
        bMXJobData.addEIBAddressObject2(this.objStartCheckOne);
        bMXJobData.addEIBAddressObject2(this.objCurrentCheckIndex);
        bMXJobData.addEIBAddressObject2(this.objResponseLamp);
        bMXJobData.addEIBAddressObject2(this.objResponseBallast);
        bMXJobData.addEIBAddressObject2(this.objStateLamp);
        bMXJobData.addEIBAddressObject2(this.objStateBallast);
        bMXJobData.addEIBAddressObject2(this.objDefectOut);
        bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        return bMXJobData;
    }

    @Override
    public JsonObject getJsonJobData() {
        return super.getJsonJobData();
    }

    @Override
    public void setJsonJobData(JsonObject jsonObject) {
        super.setJsonJobData(jsonObject);
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        return string2;
    }

    public boolean getDelayStatusFeedback() {
        return (this.flags & 1) != 0;
    }

    public void setDelayStatusFeedback(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public long getOutAvailable() {
        return this.outAvailable;
    }

    public boolean getOutAvailable(int n) {
        return (this.outAvailable >> 63 - n & 1L) != 0L;
    }

    public void setOutActive(int n, boolean bl) {
        this.outAvailable = bl ? (this.outAvailable |= 1L << 63 - n) : (this.outAvailable &= 1L << 63 - n ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public String[] getOutTitles() {
        return this.outTitle;
    }

    public String getOutTitle(int n) {
        return this.outTitle[n];
    }

    public void setOutTitle(int n, String string) {
        this.outTitle[n] = string;
    }

    public int getRequestInterval() {
        return this.requestInterval;
    }

    public void setRequestInterval(int n) {
        this.requestInterval = n;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStartCheckAll() {
        return this.objStartCheckAll;
    }

    public void setObjStartCheckAll(EIBAddressObject2 eIBAddressObject2) {
        this.objStartCheckAll = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStartCheckOne() {
        return this.objStartCheckOne;
    }

    public void setObjStartCheckOne(EIBAddressObject2 eIBAddressObject2) {
        this.objStartCheckOne = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjCurrentCheckIndex() {
        return this.objCurrentCheckIndex;
    }

    public void setObjCurrentCheckIndex(EIBAddressObject2 eIBAddressObject2) {
        this.objCurrentCheckIndex = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjResponseLamp() {
        return this.objResponseLamp;
    }

    public void setObjResponseLamp(EIBAddressObject2 eIBAddressObject2) {
        this.objResponseLamp = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjResponseBallast() {
        return this.objResponseBallast;
    }

    public void setObjResponseBallast(EIBAddressObject2 eIBAddressObject2) {
        this.objResponseBallast = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStateLamp() {
        return this.objStateLamp;
    }

    public void setObjStateLamp(EIBAddressObject2 eIBAddressObject2) {
        this.objStateLamp = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStateBallast() {
        return this.objStateBallast;
    }

    public void setObjStateBallast(EIBAddressObject2 eIBAddressObject2) {
        this.objStateBallast = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjDefectOut() {
        return this.objDefectOut;
    }

    public void setObjDefectOut(EIBAddressObject2 eIBAddressObject2) {
        this.objDefectOut = eIBAddressObject2;
    }
}

