/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.rtr;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BMXRTRModel
extends BMXJobModel {
    public static final int JOBS_RTR_FLAGS_DUMP = 1;
    public static final int JOBS_RTR_FLAGS_SIMULATE_PT1 = 2;
    public static final int JOBS_RTR_FLAGS_SQUEEZE_TIME = 4;
    public static final int JOBS_RTR_FLAGS_ALL = 7;
    public static final byte OP_MODE_NOTHING = 0;
    public static final byte OP_MODE_COMFORT = 1;
    public static final byte OP_MODE_STANDBY = 2;
    public static final byte OP_MODE_NIGHT_SETBACK = 3;
    public static final byte OP_MODE_ANTIFREEZE = 4;
    public static final byte MODE_OFF = 0;
    public static final byte MODE_NORMAL = 1;
    public static final byte MODE_COMFORT_EXTENSION = 2;
    private byte flags;
    private byte version;
    private float setpointBaseInitial = 21.0f;
    private SetpointTemp heating = new SetpointTemp();
    private SetpointTemp cooling = new SetpointTemp();
    private InputTemp input1 = new InputTemp();
    private InputTemp input2 = new InputTemp();
    private int comfortExtensionMins;
    private byte fallbackOpMode;
    private byte fallbackMode;
    private float fallbackActuatingOff;
    private float fallbackActuatingError;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objTempSetpoint;
    private EIBAddressObject2 objTempSetpointBase;
    private EIBAddressObject2 objTempSetpointAdjustment;
    private EIBAddressObject2 objTempCurrent1;
    private EIBAddressObject2 objTempCurrent2;
    private EIBAddressObject2 objActuating;
    private EIBAddressObject2 objWindow;
    private EIBAddressObject2 objOpMode;
    private EIBAddressObject2 objComfortExtension;
    private EIBAddressObject2 objMode;
    private EIBAddressObject2 objStatusEis14;

    public BMXRTRModel(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXRTRModel() {
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public float getSetpointBaseInitial() {
        return this.setpointBaseInitial;
    }

    public void setSetpointBaseInitial(float f) {
        this.setpointBaseInitial = f;
    }

    public int getComfortExtensionMins() {
        return this.comfortExtensionMins;
    }

    public void setComfortExtensionMins(int n) {
        this.comfortExtensionMins = n;
    }

    public byte getFallbackOpMode() {
        return this.fallbackOpMode;
    }

    public void setFallbackOpMode(byte by) {
        this.fallbackOpMode = by;
    }

    public byte getFallbackMode() {
        return this.fallbackMode;
    }

    public void setFallbackMode(byte by) {
        this.fallbackMode = by;
    }

    public float getFallbackActuatingOff() {
        return this.fallbackActuatingOff;
    }

    public void setFallbackActuatingOff(float f) {
        this.fallbackActuatingOff = f;
    }

    public float getFallbackActuatingError() {
        return this.fallbackActuatingError;
    }

    public void setFallbackActuatingError(float f) {
        this.fallbackActuatingError = f;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempSetpoint() {
        return this.objTempSetpoint;
    }

    public void setObjTempSetpoint(EIBAddressObject2 eIBAddressObject2) {
        this.objTempSetpoint = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempSetpointBase() {
        return this.objTempSetpointBase;
    }

    public void setObjTempSetpointBase(EIBAddressObject2 eIBAddressObject2) {
        this.objTempSetpointBase = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempSetpointAdjustment() {
        return this.objTempSetpointAdjustment;
    }

    public void setObjTempSetpointAdjustment(EIBAddressObject2 eIBAddressObject2) {
        this.objTempSetpointAdjustment = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempCurrent1() {
        return this.objTempCurrent1;
    }

    public void setObjTempCurrent1(EIBAddressObject2 eIBAddressObject2) {
        this.objTempCurrent1 = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTempCurrent2() {
        return this.objTempCurrent2;
    }

    public void setObjTempCurrent2(EIBAddressObject2 eIBAddressObject2) {
        this.objTempCurrent2 = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjActuating() {
        return this.objActuating;
    }

    public void setObjActuating(EIBAddressObject2 eIBAddressObject2) {
        this.objActuating = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjWindow() {
        return this.objWindow;
    }

    public void setObjWindow(EIBAddressObject2 eIBAddressObject2) {
        this.objWindow = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjOpMode() {
        return this.objOpMode;
    }

    public void setObjOpMode(EIBAddressObject2 eIBAddressObject2) {
        this.objOpMode = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjComfortExtension() {
        return this.objComfortExtension;
    }

    public void setObjComfortExtension(EIBAddressObject2 eIBAddressObject2) {
        this.objComfortExtension = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjMode() {
        return this.objMode;
    }

    public void setObjMode(EIBAddressObject2 eIBAddressObject2) {
        this.objMode = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjStatusEis14() {
        return this.objStatusEis14;
    }

    public void setObjStatusEis14(EIBAddressObject2 eIBAddressObject2) {
        this.objStatusEis14 = eIBAddressObject2;
    }

    public byte getVersion() {
        return this.version;
    }

    public SetpointTemp getHeating() {
        return this.heating;
    }

    public SetpointTemp getCooling() {
        return this.cooling;
    }

    public InputTemp getInput1() {
        return this.input1;
    }

    public InputTemp getInput2() {
        return this.input2;
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n = 0;
        this.flags = byArray[n++];
        this.version = byArray[n++];
        this.setpointBaseInitial = ByteConv.byte2float(byArray, n);
        n += 4;
        n = this.heating.setData(byArray, n);
        n = this.cooling.setData(byArray, n);
        n = this.input1.setData(byArray, n);
        n = this.input2.setData(byArray, n);
        this.comfortExtensionMins = ByteConv.byte2short(byArray, n);
        n += 2;
        this.fallbackOpMode = byArray[n++];
        this.fallbackMode = byArray[n++];
        this.fallbackActuatingOff = ByteConv.byte2float(byArray, n);
        this.fallbackActuatingError = ByteConv.byte2float(byArray, n += 4);
        n += 4;
        int n2 = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempSetpoint = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempSetpointBase = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempSetpointAdjustment = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempCurrent1 = bMXJobData.getEIBAddressObject2(n2++);
        this.objTempCurrent2 = bMXJobData.getEIBAddressObject2(n2++);
        this.objActuating = bMXJobData.getEIBAddressObject2(n2++);
        this.objWindow = bMXJobData.getEIBAddressObject2(n2++);
        this.objOpMode = bMXJobData.getEIBAddressObject2(n2++);
        this.objComfortExtension = bMXJobData.getEIBAddressObject2(n2++);
        this.objMode = bMXJobData.getEIBAddressObject2(n2++);
        this.objStatusEis14 = bMXJobData.getEIBAddressObject2(n2++);
    }

    @Override
    public BMXJobData getJobData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.flags);
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(ByteConv.float2byte(this.setpointBaseInitial));
            this.heating.getData(byteArrayOutputStream);
            this.cooling.getData(byteArrayOutputStream);
            this.input1.getData(byteArrayOutputStream);
            this.input2.getData(byteArrayOutputStream);
            byteArrayOutputStream.write(ByteConv.short2byte(this.comfortExtensionMins));
            byteArrayOutputStream.write(this.fallbackOpMode);
            byteArrayOutputStream.write(this.fallbackMode);
            byteArrayOutputStream.write(ByteConv.float2byte(this.fallbackActuatingOff));
            byteArrayOutputStream.write(ByteConv.float2byte(this.fallbackActuatingError));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_RTR, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objTempSetpoint);
        bMXJobData.addEIBAddressObject2(this.objTempSetpointBase);
        bMXJobData.addEIBAddressObject2(this.objTempSetpointAdjustment);
        bMXJobData.addEIBAddressObject2(this.objTempCurrent1);
        bMXJobData.addEIBAddressObject2(this.objTempCurrent2);
        bMXJobData.addEIBAddressObject2(this.objActuating);
        bMXJobData.addEIBAddressObject2(this.objWindow);
        bMXJobData.addEIBAddressObject2(this.objOpMode);
        bMXJobData.addEIBAddressObject2(this.objComfortExtension);
        bMXJobData.addEIBAddressObject2(this.objMode);
        bMXJobData.addEIBAddressObject2(this.objStatusEis14);
        return bMXJobData;
    }

    public class SetpointTemp {
        private float offsetComfort;
        private float offsetStandby;
        private float offsetNight;
        private float frostHeat;
        private float tempHysteresis;
        private float adjustmentStep = 0.5f;

        private SetpointTemp() {
        }

        int setData(byte[] byArray, int n) {
            this.offsetComfort = ByteConv.byte2float(byArray, n);
            this.offsetStandby = ByteConv.byte2float(byArray, n += 4);
            this.offsetNight = ByteConv.byte2float(byArray, n += 4);
            this.frostHeat = ByteConv.byte2float(byArray, n += 4);
            this.tempHysteresis = ByteConv.byte2float(byArray, n += 4);
            this.adjustmentStep = ByteConv.byte2float(byArray, n += 4);
            return n += 4;
        }

        void getData(OutputStream outputStream) throws IOException {
            outputStream.write(ByteConv.float2byte(this.offsetComfort));
            outputStream.write(ByteConv.float2byte(this.offsetStandby));
            outputStream.write(ByteConv.float2byte(this.offsetNight));
            outputStream.write(ByteConv.float2byte(this.frostHeat));
            outputStream.write(ByteConv.float2byte(this.tempHysteresis));
            outputStream.write(ByteConv.float2byte(this.adjustmentStep));
        }

        public float getOffsetComfort() {
            return this.offsetComfort;
        }

        public void setOffsetComfort(float f) {
            this.offsetComfort = f;
        }

        public float getOffsetStandby() {
            return this.offsetStandby;
        }

        public void setOffsetStandby(float f) {
            this.offsetStandby = f;
        }

        public float getOffsetNight() {
            return this.offsetNight;
        }

        public void setOffsetNight(float f) {
            this.offsetNight = f;
        }

        public float getFrostHeat() {
            return this.frostHeat;
        }

        public void setFrostHeat(float f) {
            this.frostHeat = f;
        }

        public float getTempHysteresis() {
            return this.tempHysteresis;
        }

        public void setTempHysteresis(float f) {
            this.tempHysteresis = f;
        }

        public float getAdjustmentStep() {
            return this.adjustmentStep;
        }

        public void setAdjustmentStep(float f) {
            this.adjustmentStep = f;
        }
    }

    public class InputTemp {
        private float offset;
        private float weight;
        private int timeoutMins;

        private InputTemp() {
        }

        int setData(byte[] byArray, int n) {
            this.offset = ByteConv.byte2float(byArray, n);
            this.weight = ByteConv.byte2float(byArray, n += 4);
            this.timeoutMins = ByteConv.byte2short(byArray, n += 4);
            return n += 2;
        }

        void getData(OutputStream outputStream) throws IOException {
            outputStream.write(ByteConv.float2byte(this.offset));
            outputStream.write(ByteConv.float2byte(this.weight));
            outputStream.write(ByteConv.short2byte(this.timeoutMins));
        }

        public float getOffset() {
            return this.offset;
        }

        public void setOffset(float f) {
            this.offset = f;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float f) {
            this.weight = f;
        }

        public int getTimeoutMins() {
            return this.timeoutMins;
        }

        public void setTimeoutMins(int n) {
            this.timeoutMins = n;
        }
    }
}

