/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.weektimer;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.weektimer.WeekTimerEvent;
import de.babtec.globals.knx.address.EIBAddressObject2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BMXWeekTimer
extends BMXJobModel {
    public static final int DAY_SUNDAY = 0;
    public static final int DAY_MONDAY = 1;
    public static final int DAY_TUESDAY = 2;
    public static final int DAY_WEDNESDAY = 3;
    public static final int DAY_THURSDAY = 4;
    public static final int DAY_FRIDAY = 5;
    public static final int DAY_SATURDAY = 6;
    public static final int DAY_SPECIAL1 = 7;
    public static final int DAY_SPECIAL2 = 8;
    public static final int DAY_SPECIAL3 = 9;
    public static final int[] days = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private ArrayList<WeekTimerEvent> eventData = new ArrayList();
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objOutput;
    private byte flags;
    private boolean initOnModification = false;
    private boolean initOnStart = false;
    private boolean preventOverride = false;
    private boolean watchTimeSkip = true;

    public BMXWeekTimer(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXWeekTimer() {
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        this.flags = byArray[0];
        this.flags = (byte)(this.flags & 0xC7);
        this.preventOverride = (this.flags & 1) > 0;
        this.initOnStart = (this.flags & 2) > 0;
        this.initOnModification = (this.flags & 4) > 0;
        this.watchTimeSkip = (this.flags & 0x40) > 0;
        byte[] byArray2 = new byte[3600];
        System.arraycopy(byArray, 4, byArray2, 0, 3600);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 360; ++j) {
                this.handleMinute(i, j * 4, byArray2[i * 360 + j] & 3);
                this.handleMinute(i, j * 4 + 1, byArray2[i * 360 + j] >> 2 & 3);
                this.handleMinute(i, j * 4 + 2, byArray2[i * 360 + j] >> 4 & 3);
                this.handleMinute(i, j * 4 + 3, byArray2[i * 360 + j] >> 6 & 3);
            }
        }
        this.objEnable = bMXJobData.getEIBAddressObject2(0);
        this.objOutput = bMXJobData.getEIBAddressObject2(1);
    }

    private void handleMinute(int n, int n2, int n3) {
        if ((n3 & 2) > 0) {
            this.eventData.add(new WeekTimerEvent(n, n2, n3 & 1));
        }
    }

    public void sortEvents() {
        Collections.sort(this.eventData, new Comparator<WeekTimerEvent>(){

            @Override
            public int compare(WeekTimerEvent weekTimerEvent, WeekTimerEvent weekTimerEvent2) {
                if (weekTimerEvent.getDay() == weekTimerEvent2.getDay()) {
                    return weekTimerEvent.getMinute() - weekTimerEvent2.getMinute();
                }
                return weekTimerEvent.getDay() - weekTimerEvent2.getDay();
            }
        });
    }

    @Override
    public BMXJobData getJobData() {
        byte[] byArray = new byte[3604];
        byArray[0] = (byte)(this.flags & 0xB8);
        byArray[0] = (byte)(byArray[0] | 0x80);
        byArray[0] = (byte)(byArray[0] | (this.preventOverride ? (byte)1 : 0));
        byArray[0] = (byte)(byArray[0] | (this.initOnStart ? 2 : 0));
        byArray[0] = (byte)(byArray[0] | (this.initOnModification ? 4 : 0));
        byArray[0] = (byte)(byArray[0] | (this.watchTimeSkip ? 64 : 0));
        this.sortEvents();
        byte[] byArray2 = new byte[3600];
        for (WeekTimerEvent weekTimerEvent : this.eventData) {
            int n;
            int n2 = n = weekTimerEvent.getDay() * 360 + (int)Math.floor(weekTimerEvent.getMinute() / 4);
            byArray2[n2] = (byte)(byArray2[n2] | (2 | weekTimerEvent.getAction()) << weekTimerEvent.getMinute() % 4 * 2);
        }
        this.cleanData(byArray2, 0, 2520);
        this.cleanData(byArray2, 2520, 2880);
        this.cleanData(byArray2, 2880, 3240);
        this.cleanData(byArray2, 3240, 3600);
        System.arraycopy(byArray2, 0, byArray, 4, 3600);
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_WEEKTIMER, byArray);
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objOutput);
        return bMXJobData;
    }

    private void cleanData(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = this.cleanMinute(byArray, i, 0, n3);
            n3 = this.cleanMinute(byArray, i, 2, n3);
            n3 = this.cleanMinute(byArray, i, 4, n3);
            n3 = this.cleanMinute(byArray, i, 6, n3);
        }
    }

    private int cleanMinute(byte[] byArray, int n, int n2, int n3) {
        int n4 = byArray[n] >> n2 & 3;
        if ((n4 & 2) > 0) {
            n3 = n4 & 1;
        } else {
            int n5 = n;
            byArray[n5] = (byte)(byArray[n5] | n3 << n2);
        }
        return n3;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objOutput = eIBAddressObject2;
    }

    public boolean isInitOnModification() {
        return this.initOnModification;
    }

    public void setInitOnModification(boolean bl) {
        this.initOnModification = bl;
    }

    public boolean isInitOnStart() {
        return this.initOnStart;
    }

    public void setInitOnStart(boolean bl) {
        this.initOnStart = bl;
    }

    public boolean isPreventOverride() {
        return this.preventOverride;
    }

    public void setPreventOverride(boolean bl) {
        this.preventOverride = bl;
    }

    public boolean isHandleTimeLapse() {
        return this.watchTimeSkip;
    }

    public void setHandleTimeLapse(boolean bl) {
        this.watchTimeSkip = bl;
    }

    public WeekTimerEvent[] getEvents() {
        return this.eventData.toArray(new WeekTimerEvent[this.eventData.size()]);
    }

    public boolean removeEvent(WeekTimerEvent weekTimerEvent) {
        return this.eventData.remove(weekTimerEvent);
    }

    public boolean addEvent(WeekTimerEvent weekTimerEvent) {
        if (this.containsEvent(weekTimerEvent.getDay(), weekTimerEvent.getMinute())) {
            return false;
        }
        this.eventData.add(weekTimerEvent);
        this.sortEvents();
        return true;
    }

    public void addEvents(WeekTimerEvent[] weekTimerEventArray) {
        for (WeekTimerEvent weekTimerEvent : weekTimerEventArray) {
            if (this.containsEvent(weekTimerEvent.getDay(), weekTimerEvent.getMinute())) {
                this.removeEvent(weekTimerEvent);
            }
            this.eventData.add(weekTimerEvent);
        }
        this.sortEvents();
    }

    public boolean containsEvent(int n, int n2) {
        for (WeekTimerEvent weekTimerEvent : this.eventData) {
            if (weekTimerEvent.getDay() != n || weekTimerEvent.getMinute() != n2) continue;
            return true;
        }
        return false;
    }
}

