/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.yeartimer;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;

public class BMXYearTimer
extends BMXJobModel {
    public static final int MONTH_JANUARY = 0;
    public static final int MONTH_FEBRUARY = 1;
    public static final int MONTH_MARCH = 2;
    public static final int MONTH_APRIL = 3;
    public static final int MONTH_MAY = 4;
    public static final int MONTH_JUNE = 5;
    public static final int MONTH_JULY = 6;
    public static final int MONTH_AUGUST = 7;
    public static final int MONTH_SEPTEMBER = 8;
    public static final int MONTH_OCTOBER = 9;
    public static final int MONTH_NOVEMBER = 10;
    public static final int MONTH_DECEMBER = 11;
    public static final int[] months = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objOutput;
    private byte flags;
    private boolean binary = false;
    private boolean initOnStart = false;
    private boolean preventOverride = false;
    private boolean watchTimeSkip = true;
    private byte[] timerData = new byte[372];

    public BMXYearTimer(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXYearTimer() {
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        this.flags = byArray[0];
        this.preventOverride = (this.flags & 1) > 0;
        this.initOnStart = (this.flags & 2) > 0;
        this.watchTimeSkip = (this.flags & 0x40) > 0;
        this.binary = (this.flags & 8) == 1;
        System.arraycopy(byArray, 4, this.timerData, 0, 372);
        this.objEnable = bMXJobData.getEIBAddressObject2(0);
        this.objOutput = bMXJobData.getEIBAddressObject2(1);
    }

    @Override
    public BMXJobData getJobData() {
        byte[] byArray = new byte[376];
        byArray[0] = (byte)(this.flags & 0xB8);
        byArray[0] = (byte)(byArray[0] | 0x80);
        byArray[0] = (byte)(byArray[0] | (this.preventOverride ? (byte)1 : 0));
        byArray[0] = (byte)(byArray[0] | (this.initOnStart ? 2 : 0));
        byArray[0] = (byte)(byArray[0] | (this.binary ? 8 : 0));
        byArray[0] = (byte)(byArray[0] | (this.watchTimeSkip ? 64 : 0));
        System.arraycopy(this.timerData, 0, byArray, 4, this.timerData.length);
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_YEARTIMER, byArray);
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objOutput);
        return bMXJobData;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objOutput = eIBAddressObject2;
    }

    public boolean isInitOnStart() {
        return this.initOnStart;
    }

    public void setInitOnStart(boolean bl) {
        this.initOnStart = bl;
    }

    public boolean isPreventOverride() {
        return this.preventOverride;
    }

    public void setPreventOverride(boolean bl) {
        this.preventOverride = bl;
    }

    public boolean isHandleTimeLapse() {
        return this.watchTimeSkip;
    }

    public void setHandleTimeLapse(boolean bl) {
        this.watchTimeSkip = bl;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean bl) {
        this.binary = bl;
    }

    public byte[] getData() {
        return this.timerData;
    }

    public void setData(byte[] byArray) {
        if (byArray.length != 372) {
            return;
        }
        this.timerData = byArray;
    }
}

