/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.address;

import de.babtec.globals.bmx.BMXTelegram;
import de.babtec.globals.knx.address.EIBAddress2;
import de.babtec.globals.knx.address.EIBAddressListener2;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EIBAddressObject2 {
    public static final int TYPE_ADDRESSOBJECT = 0;
    public static final int TYPE_ADDRESS = 1;
    public static final int ADDRESSOBJECT_MAX_ADDRESS_COUNT = 5;
    public static final String OBJECT = "(?:\\d+\\/){1,2}\\d+";
    public static final String COMMUNICATION_OBJECT = "\\A((?:\\d+\\/){1,2}\\d+){1}(?:\\(((?:\\d+\\/){1,2}\\d+){1}(?:,((?:\\d+\\/){1,2}\\d+))?(?:,((?:\\d+\\/){1,2}\\d+))?(?:,((?:\\d+\\/){1,2}\\d+))?\\))?\\Z";
    public static final Pattern PATTERN = Pattern.compile("\\A((?:\\d+\\/){1,2}\\d+){1}(?:\\(((?:\\d+\\/){1,2}\\d+){1}(?:,((?:\\d+\\/){1,2}\\d+))?(?:,((?:\\d+\\/){1,2}\\d+))?(?:,((?:\\d+\\/){1,2}\\d+))?\\))?\\Z", 64);
    private ArrayList<EIBAddress2> addresses = new ArrayList();
    private ArrayList<EIBAddressListener2> listeners = new ArrayList();
    private boolean active = true;
    private BMXTelegram currentTelegram;

    public EIBAddressObject2(String string) {
        this.active = this.parseEIBAddress(string);
    }

    public EIBAddressObject2(EIBAddress2 eIBAddress2) {
        this.addAddress(eIBAddress2);
    }

    public EIBAddressObject2(int[] nArray) {
        if (nArray == null) {
            return;
        }
        for (int n : nArray) {
            if (n == 0) break;
            this.addresses.add(EIBAddress2.getAddress(n));
        }
    }

    public int[] getAddressObjectAsInteger() {
        int[] nArray = new int[this.getAddressCount()];
        for (int i = 0; i < this.getAddressCount(); ++i) {
            nArray[i] = this.addresses.get(i).getIntAddress();
        }
        return nArray;
    }

    public int getAddressCount() {
        return this.addresses.size();
    }

    public boolean containsAddress(int n) {
        for (EIBAddress2 eIBAddress2 : this.addresses) {
            if (eIBAddress2.getIntAddress() != n) continue;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getAddressObjectAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.addresses.size() > 0) {
            stringBuffer.append(this.addresses.get(0).getStrAddress());
            if (this.addresses.size() > 1) {
                stringBuffer.append("(");
                for (int i = 1; i < this.addresses.size(); ++i) {
                    if (i > 1) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.addresses.get(i).getStrAddress());
                }
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public EIBAddress2 getAddress(int n) {
        if (n < this.addresses.size()) {
            return this.addresses.get(n);
        }
        return null;
    }

    public int getSendAddress() {
        if (this.getAddressCount() == 0) {
            return -1;
        }
        return this.getAddress(0).getIntAddress();
    }

    public void addAddress(EIBAddress2 eIBAddress2) {
        if (eIBAddress2 == null) {
            return;
        }
        this.addresses.add(eIBAddress2);
    }

    public void addAddress(EIBAddress2 eIBAddress2, int n) {
        if (eIBAddress2 == null) {
            return;
        }
        this.addresses.add(n, eIBAddress2);
    }

    public void makeMaster(int n) {
        this.addresses.add(0, this.addresses.remove(n));
    }

    public void removeAddress(int n) {
        this.addresses.remove(n);
    }

    public static boolean isValidAddressObjectString(String string) {
        Matcher matcher;
        if (string != null && (matcher = PATTERN.matcher(string)).matches()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                if (matcher.group(i + 1) == null || EIBAddress2.isValid(matcher.group(i + 1))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseEIBAddress(String string) {
        Integer[] integerArray = EIBAddressObject2.getAddresses(string);
        if (integerArray == null) {
            return false;
        }
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            this.addAddress(EIBAddress2.getAddress(n2));
        }
        return true;
    }

    public void newTelegram(BMXTelegram bMXTelegram) {
        if (bMXTelegram == null) {
            return;
        }
        for (EIBAddress2 eIBAddress2 : this.addresses) {
            int n;
            if (eIBAddress2.getIntAddress() != bMXTelegram.getAddress()) continue;
            if (this.currentTelegram != null && !(this.currentTelegram.getDate() <= bMXTelegram.getDate()) || (n = bMXTelegram.getStatusFunction()) != 1 && n != 2 && n != 5 && n != 6 && n != 7) break;
            this.currentTelegram = bMXTelegram;
            for (EIBAddressListener2 eIBAddressListener2 : this.listeners) {
                try {
                    eIBAddressListener2.addressUpdated(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public BMXTelegram getLastTelegram() {
        return this.currentTelegram;
    }

    public void addEIBAddressListener2(EIBAddressListener2 eIBAddressListener2) {
        this.listeners.add(eIBAddressListener2);
    }

    public void removeEIBAddressListener2(EIBAddressListener2 eIBAddressListener2) {
        this.listeners.remove(eIBAddressListener2);
    }

    public boolean initialize() {
        return this.getInitializationPackage() != null;
    }

    public byte[] getInitializationPackage() {
        return null;
    }

    public static Integer[] getAddresses(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.matches()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                int n = EIBAddress2.getValidAddress(matcher.group(i));
                if (n == -1) continue;
                arrayList.add(n);
            }
            return arrayList.toArray(new Integer[arrayList.size()]);
        }
        return null;
    }
}

