/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype;

import de.babtec.globals.knx.datatype.DT_Unknown;
import de.babtec.globals.knx.datatype.dpt.DT_Dpt_29;
import de.babtec.globals.knx.datatype.dpt.DT_Dpt_6_010;
import de.babtec.globals.knx.datatype.eis.DT_Eis1;
import de.babtec.globals.knx.datatype.eis.DT_Eis10s;
import de.babtec.globals.knx.datatype.eis.DT_Eis10u;
import de.babtec.globals.knx.datatype.eis.DT_Eis11s;
import de.babtec.globals.knx.datatype.eis.DT_Eis11u;
import de.babtec.globals.knx.datatype.eis.DT_Eis14s;
import de.babtec.globals.knx.datatype.eis.DT_Eis14u;
import de.babtec.globals.knx.datatype.eis.DT_Eis15;
import de.babtec.globals.knx.datatype.eis.DT_Eis2_abs;
import de.babtec.globals.knx.datatype.eis.DT_Eis2_rel;
import de.babtec.globals.knx.datatype.eis.DT_Eis2_switch;
import de.babtec.globals.knx.datatype.eis.DT_Eis3;
import de.babtec.globals.knx.datatype.eis.DT_Eis4;
import de.babtec.globals.knx.datatype.eis.DT_Eis5;
import de.babtec.globals.knx.datatype.eis.DT_Eis6;
import de.babtec.globals.knx.datatype.eis.DT_Eis9;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class DataType<T>
implements Comparable {
    public static final int DATATYPE_UNKNOWN = 0;
    public static final int DATATYPE_URL = 200;
    public static final int DATATYPE_EIS1 = 10000010;
    public static final int DATATYPE_EIS2_switch = 10000020;
    public static final int DATATYPE_EIS2_rel = 10000021;
    public static final int DATATYPE_EIS2_abs = 0x989696;
    public static final int DATATYPE_EIS3 = 10000030;
    public static final int DATATYPE_EIS4 = 10000040;
    public static final int DATATYPE_EIS5 = 10000050;
    public static final int DATATYPE_EIS6 = 10000060;
    public static final int DATATYPE_EIS7 = 10000070;
    public static final int DATATYPE_EIS8 = 10000080;
    public static final int DATATYPE_EIS9 = 10000090;
    public static final int DATATYPE_EIS10s = 10000100;
    public static final int DATATYPE_EIS10u = 10000101;
    public static final int DATATYPE_EIS11s = 10000110;
    public static final int DATATYPE_EIS11u = 10000111;
    public static final int DATATYPE_EIS12 = 10000120;
    public static final int DATATYPE_EIS13 = 10000130;
    public static final int DATATYPE_EIS14s = 10000140;
    public static final int DATATYPE_EIS14u = 10000141;
    public static final int DATATYPE_EIS15 = 10000150;
    public static final int DEPRECATED_DATATYPE_DPT6_010 = 1006010;
    public static final int DEPRECATED_DATATYPE_DPT29 = 1029000;
    public static final int DATATYPE_DPT_1 = 100010000;
    public static final int DATATYPE_DPT_1_001 = 200010001;
    public static final int DATATYPE_DPT_1_002 = 200010002;
    public static final int DATATYPE_DPT_1_003 = 200010003;
    public static final int DATATYPE_DPT_1_006 = 200010006;
    public static final int DATATYPE_DPT_1_008 = 200010008;
    public static final int DATATYPE_DPT_1_009 = 200010009;
    public static final int DATATYPE_DPT_1_100 = 200011000;
    public static final int DATATYPE_DPT_2_001 = 200020001;
    public static final int DATATYPE_DPT_3_007 = 200030007;
    public static final int DATATYPE_DPT_4_001 = 200040001;
    public static final int DATATYPE_DPT_5_001 = 200050001;
    public static final int DATATYPE_DPT_5_010 = 200050010;
    public static final int DATATYPE_DPT_6_010 = 200060010;
    public static final int DATATYPE_DPT_7_001 = 200070001;
    public static final int DATATYPE_DPT_8_001 = 200080001;
    public static final int DATATYPE_DPT_9 = 100090000;
    public static final int DATATYPE_DPT_9_001 = 200090001;
    public static final int DATATYPE_DPT_10_001 = 200100001;
    public static final int DATATYPE_DPT_11_001 = 200110001;
    public static final int DATATYPE_DPT_12_001 = 200120001;
    public static final int DATATYPE_DPT_13_001 = 200130001;
    public static final int DATATYPE_DPT_14 = 100140000;
    public static final int DATATYPE_DPT_14_000 = 200140000;
    public static final int DATATYPE_DPT_15_000 = 200150000;
    public static final int DATATYPE_DPT_16_000 = 200160000;
    public static final int DATATYPE_DPT_16_001 = 200160001;
    public static final int DATATYPE_DPT_29 = 100290000;
    public static final int DATATYPE_DPT_29_010 = 200290010;
    public static final int DATATYPE_DPT_29_011 = 200290011;
    public static final int DATATYPE_DPT_29_012 = 200290012;
    protected DecimalFormat df = new DecimalFormat();
    private static HashMap<Integer, DataType<?>> DATATYPE_MAP = new HashMap();
    public static final HashMap<Integer, Integer> EIS_TO_DPT = new HashMap();
    private int typeIndex;
    private String title;

    public DataType() {
        this.df.setMultiplier(1);
    }

    public static final DataType<?>[] getDataTypes() {
        ArrayList arrayList = new ArrayList();
        for (DataType<?> dataType : DATATYPE_MAP.values()) {
            if (arrayList.contains(dataType)) continue;
            arrayList.add(dataType);
        }
        return arrayList.toArray(new DataType[arrayList.size()]);
    }

    public static final DataType<?> getDataType(int n) {
        return DATATYPE_MAP.get(n);
    }

    public static final DataType<?> getBMXDataType(int n) {
        switch (n) {
            case 1: {
                return DATATYPE_MAP.get(10000010);
            }
            case 3: {
                return DATATYPE_MAP.get(10000021);
            }
            case 7: {
                return DATATYPE_MAP.get(10000030);
            }
            case 8: {
                return DATATYPE_MAP.get(10000040);
            }
            case 5: {
                return DATATYPE_MAP.get(10000050);
            }
            case 4: {
                return DATATYPE_MAP.get(10000060);
            }
            case 2: {
                return DATATYPE_MAP.get(10000080);
            }
            case 9: {
                return DATATYPE_MAP.get(10000090);
            }
            case 6: {
                return DATATYPE_MAP.get(10000101);
            }
            case 10: {
                return DATATYPE_MAP.get(10000111);
            }
            case 11: {
                return DATATYPE_MAP.get(10000141);
            }
            case 12: {
                return DATATYPE_MAP.get(10000150);
            }
        }
        return DATATYPE_MAP.get(0);
    }

    protected DataType(int n, String string) {
        this.typeIndex = n;
        this.title = string;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public String toString() {
        return this.title;
    }

    public boolean getFactorEnabled() {
        return true;
    }

    public boolean getOffsetEnabled() {
        return true;
    }

    public boolean getMinEnabled() {
        return true;
    }

    public boolean getMaxEnabled() {
        return true;
    }

    public boolean getFormatEnabled() {
        return true;
    }

    public String getPrintfFormat() {
        return "%f";
    }

    public abstract T getMinValue();

    public abstract T getMaxValue();

    public abstract boolean isInRange(T var1, double var2, double var4);

    public abstract boolean isInThisRange(T var1, double var2, double var4);

    public abstract T getValueInRange(T var1, double var2, double var4);

    public abstract T getValueInThisRange(T var1, double var2, double var4);

    public abstract byte[] getData(T var1);

    public abstract byte[] getData(T var1, double var2, double var4);

    public abstract T getValue(byte[] var1);

    public abstract T getValue(byte[] var1, double var2, double var4);

    public abstract Double getDoubleValue(T var1);

    public abstract T getDataValue(Double var1);

    public Double getDoubleValue(byte[] byArray, double d, double d2) {
        return this.getDoubleValue(this.getValue(byArray)) * d + d2;
    }

    public String formatDoubleValue(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(d);
    }

    public abstract String getValueAsString(T var1);

    public abstract String getValuePrefix();

    public abstract String getValuePostfix();

    public abstract String formatValue(T var1, String var2);

    public abstract T parseValue(String var1) throws Exception;

    public abstract T parseValue(String var1, String var2) throws Exception;

    protected Short getValueInRange(Short s, double d, double d2, short s2, short s3) {
        Short s4 = Double.valueOf(((double)s.shortValue() - d2) / d).shortValue();
        s4 = s4 < s2 ? s2 : (s4 > s3 ? s3 : s4);
        return Double.valueOf((double)s4.shortValue() * d + d2).shortValue();
    }

    protected boolean isInRange(Short s, double d, double d2, short s2, short s3) {
        Short s4 = Double.valueOf(((double)s.shortValue() - d2) / d).shortValue();
        return s4 >= s2 && s4 <= s3;
    }

    protected Integer getValueInRange(Integer n, double d, double d2, int n2, int n3) {
        Integer n4 = Double.valueOf(((double)n.intValue() - d2) / d).intValue();
        n4 = n4 < n2 ? n2 : (n4 > n3 ? n3 : n4);
        return Double.valueOf((double)n4.intValue() * d + d2).intValue();
    }

    protected boolean isInRange(Integer n, double d, double d2, int n2, int n3) {
        Integer n4 = Double.valueOf(((double)n.intValue() - d2) / d).intValue();
        return n4 >= n2 && n4 <= n3;
    }

    protected Long getValueInRange(Long l, double d, double d2, long l2, long l3) {
        Long l4 = Double.valueOf(((double)l.longValue() - d2) / d).longValue();
        l4 = l4 < l2 ? l2 : (l4 > l3 ? l3 : l4);
        return Double.valueOf((double)l4.longValue() * d + d2).longValue();
    }

    protected boolean isInRange(Long l, double d, double d2, long l2, long l3) {
        Long l4 = Double.valueOf(((double)l.longValue() - d2) / d).longValue();
        return l4 >= l2 && l4 <= l3;
    }

    protected Float getValueInRange(Float f, double d, double d2, float f2, float f3) {
        Float f4 = Float.valueOf(Double.valueOf(((double)f.floatValue() - d2) / d).floatValue());
        f4 = Float.valueOf(f4.floatValue() < f2 ? f2 : (f4.floatValue() > f3 ? f3 : f4.floatValue()));
        return Float.valueOf(Double.valueOf((double)f4.floatValue() * d + d2).floatValue());
    }

    protected boolean isInRange(Float f, double d, double d2, float f2, float f3) {
        Float f4 = Float.valueOf(Double.valueOf(((double)f.floatValue() - d2) / d).floatValue());
        return f4.floatValue() >= f2 && f4.floatValue() <= f3;
    }

    protected Double getValueInRange(Double d, double d2, double d3, double d4, double d5) {
        double d6 = (d - d3) / d2;
        d6 = d6 < d4 ? d4 : (d6 > d5 ? d5 : d6);
        return d6 * d2 + d3;
    }

    protected boolean isInRange(Double d, double d2, double d3, double d4, double d5) {
        double d6 = (d - d3) / d2;
        return d6 >= d4 && d6 <= d5;
    }

    public abstract int getBmxDataWidth();

    public byte getBmxIndex() {
        return 0;
    }

    public static final DT_Unknown getUnknown() {
        return (DT_Unknown)DATATYPE_MAP.get(0);
    }

    public static final DT_Eis1 getEis1() {
        return (DT_Eis1)DATATYPE_MAP.get(10000010);
    }

    public static final DT_Eis3 getEis3() {
        return (DT_Eis3)DATATYPE_MAP.get(10000030);
    }

    public static final DT_Eis4 getEis4() {
        return (DT_Eis4)DATATYPE_MAP.get(10000040);
    }

    public static final DT_Eis5 getEis5() {
        return (DT_Eis5)DATATYPE_MAP.get(10000050);
    }

    public static final DT_Eis6 getEis6() {
        return (DT_Eis6)DATATYPE_MAP.get(10000060);
    }

    public static final DT_Eis9 getEis9() {
        return (DT_Eis9)DATATYPE_MAP.get(10000090);
    }

    public static final DT_Eis10s getEis10s() {
        return (DT_Eis10s)DATATYPE_MAP.get(10000100);
    }

    public static final DT_Eis10u getEis10u() {
        return (DT_Eis10u)DATATYPE_MAP.get(10000101);
    }

    public static final DT_Eis11s getEis11s() {
        return (DT_Eis11s)DATATYPE_MAP.get(10000110);
    }

    public static final DT_Eis11u getEis11u() {
        return (DT_Eis11u)DATATYPE_MAP.get(10000111);
    }

    public static final DT_Eis14s getEis14s() {
        return (DT_Eis14s)DATATYPE_MAP.get(10000140);
    }

    public static final DT_Eis14u getEis14u() {
        return (DT_Eis14u)DATATYPE_MAP.get(10000141);
    }

    public static final DT_Eis15 getEis15() {
        return (DT_Eis15)DATATYPE_MAP.get(10000150);
    }

    public static final DT_Dpt_6_010 getDpt6_010() {
        return (DT_Dpt_6_010)DATATYPE_MAP.get(200060010);
    }

    public static final DT_Dpt_29 getDpt29() {
        return (DT_Dpt_29)DATATYPE_MAP.get(100290000);
    }

    static {
        DATATYPE_MAP.put(0, new DT_Unknown());
        DATATYPE_MAP.put(10000010, new DT_Eis1());
        DATATYPE_MAP.put(10000020, new DT_Eis2_switch());
        DATATYPE_MAP.put(10000021, new DT_Eis2_rel());
        DATATYPE_MAP.put(0x989696, new DT_Eis2_abs());
        DATATYPE_MAP.put(10000030, new DT_Eis3());
        DATATYPE_MAP.put(10000040, new DT_Eis4());
        DATATYPE_MAP.put(10000050, new DT_Eis5());
        DATATYPE_MAP.put(10000060, new DT_Eis6());
        DATATYPE_MAP.put(10000090, new DT_Eis9());
        DATATYPE_MAP.put(10000100, new DT_Eis10s());
        DATATYPE_MAP.put(10000101, new DT_Eis10u());
        DATATYPE_MAP.put(10000110, new DT_Eis11s());
        DATATYPE_MAP.put(10000111, new DT_Eis11u());
        DATATYPE_MAP.put(10000140, new DT_Eis14s());
        DATATYPE_MAP.put(10000141, new DT_Eis14u());
        DATATYPE_MAP.put(10000150, new DT_Eis15());
        DATATYPE_MAP.put(100290000, new DT_Dpt_29());
        DATATYPE_MAP.put(200060010, new DT_Dpt_6_010());
        DATATYPE_MAP.put(1029000, DATATYPE_MAP.get(100290000));
        DATATYPE_MAP.put(1006010, DATATYPE_MAP.get(200060010));
        EIS_TO_DPT.put(10000010, 100010000);
        EIS_TO_DPT.put(10000021, 200030007);
        EIS_TO_DPT.put(10000020, 200010001);
        EIS_TO_DPT.put(0x989696, 200050001);
        EIS_TO_DPT.put(10000030, 200100001);
        EIS_TO_DPT.put(10000040, 200110001);
        EIS_TO_DPT.put(10000050, 100090000);
        EIS_TO_DPT.put(10000060, 200050001);
        EIS_TO_DPT.put(10000070, 200010008);
        EIS_TO_DPT.put(10000080, 200020001);
        EIS_TO_DPT.put(10000090, 100140000);
        EIS_TO_DPT.put(10000100, 200080001);
        EIS_TO_DPT.put(10000101, 200070001);
        EIS_TO_DPT.put(10000110, 200130001);
        EIS_TO_DPT.put(10000111, 200120001);
        EIS_TO_DPT.put(10000120, 200150000);
        EIS_TO_DPT.put(10000130, 200040001);
        EIS_TO_DPT.put(10000140, 200060010);
        EIS_TO_DPT.put(10000141, 200050010);
        EIS_TO_DPT.put(10000150, 200160000);
    }
}

