/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype.eis;

import de.babtec.globals.knx.datatype.DataType;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DT_Eis10s
extends DataType<Short> {
    public static final Short MIN_VALUE = Short.MIN_VALUE;
    public static final Short MAX_VALUE = Short.MAX_VALUE;

    public DT_Eis10s() {
        super(10000100, "EIS 10s (2 Byte Value)");
    }

    @Override
    public Double getDoubleValue(Short s) {
        return s.doubleValue();
    }

    @Override
    public Short getDataValue(Double d) {
        return d.shortValue();
    }

    @Override
    public Short getMaxValue() {
        return MAX_VALUE;
    }

    @Override
    public Short getMinValue() {
        return MIN_VALUE;
    }

    @Override
    public Short getValueInRange(Short s, double d, double d2) {
        return super.getValueInRange(s, d, d2, MIN_VALUE, MAX_VALUE);
    }

    @Override
    public boolean isInRange(Short s, double d, double d2) {
        return super.isInRange(s, d, d2, MIN_VALUE, MAX_VALUE);
    }

    @Override
    public Short getValueInThisRange(Short s, double d, double d2) {
        short s2 = (short)((double)MIN_VALUE.shortValue() < d ? d : (double)MIN_VALUE.shortValue());
        short s3 = (short)((double)MAX_VALUE.shortValue() > d2 ? d2 : (double)MAX_VALUE.shortValue());
        return s < s2 ? s2 : (s > s3 ? s3 : s);
    }

    @Override
    public boolean isInThisRange(Short s, double d, double d2) {
        return (double)s.shortValue() >= Math.max((double)MIN_VALUE.shortValue(), d) && (double)s.shortValue() <= Math.min((double)MAX_VALUE.shortValue(), d2);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Short s) {
        return new byte[]{(byte)((s & 0xFF00) >> 8), (byte)(s & 0xFF)};
    }

    @Override
    public byte[] getData(Short s, double d, double d2) {
        return this.getData((short)(((double)s.shortValue() - d2) / d));
    }

    @Override
    public Short getValue(byte[] byArray) {
        short s = (short)(byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8);
        return s;
    }

    @Override
    public Short getValue(byte[] byArray, double d, double d2) {
        return Double.valueOf((double)this.getValue(byArray).shortValue() * d + d2).shortValue();
    }

    @Override
    public String getValueAsString(Short s) {
        return s.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%d";
    }

    @Override
    public String formatValue(Short s, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(s);
    }

    @Override
    public Short parseValue(String string) throws Exception {
        return Short.parseShort(string);
    }

    @Override
    public Short parseValue(String string, String string2) throws Exception {
        try {
            if (string2 != null) {
                return new DecimalFormat(string2).parse(string).shortValue();
            }
        }
        catch (ParseException parseException) {
            return Short.parseShort(string);
        }
        return null;
    }

    @Override
    public int getBmxDataWidth() {
        return 6;
    }

    @Override
    public byte getBmxIndex() {
        return 6;
    }
}

