/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype.eis;

import de.babtec.globals.knx.datatype.DataType;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DT_Eis10u
extends DataType<Integer> {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;

    public DT_Eis10u() {
        super(10000101, "EIS 10u (2 Byte unsigned Value)");
    }

    @Override
    public Double getDoubleValue(Integer n) {
        return n.doubleValue();
    }

    @Override
    public Integer getDataValue(Double d) {
        return d.intValue();
    }

    @Override
    public Integer getMaxValue() {
        return 65535;
    }

    @Override
    public Integer getMinValue() {
        return 0;
    }

    @Override
    public Integer getValueInRange(Integer n, double d, double d2) {
        return super.getValueInRange(n, d, d2, 0, 65535);
    }

    @Override
    public boolean isInRange(Integer n, double d, double d2) {
        return super.isInRange(n, d, d2, 0, 65535);
    }

    @Override
    public Integer getValueInThisRange(Integer n, double d, double d2) {
        int n2 = (int)(0.0 < d ? d : 0.0);
        int n3 = (int)(65535.0 > d2 ? d2 : 65535.0);
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    @Override
    public boolean isInThisRange(Integer n, double d, double d2) {
        return (double)n.intValue() >= Math.max(0.0, d) && (double)n.intValue() <= Math.min(65535.0, d2);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Integer n) {
        return new byte[]{(byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
    }

    @Override
    public byte[] getData(Integer n, double d, double d2) {
        return this.getData((int)(((double)n.intValue() - d2) / d));
    }

    @Override
    public Integer getValue(byte[] byArray) {
        int n = byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8;
        return n;
    }

    @Override
    public Integer getValue(byte[] byArray, double d, double d2) {
        return Double.valueOf((double)this.getValue(byArray).intValue() * d + d2).intValue();
    }

    @Override
    public String getValueAsString(Integer n) {
        return n.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%d";
    }

    @Override
    public String formatValue(Integer n, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(n);
    }

    @Override
    public Integer parseValue(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    public Integer parseValue(String string, String string2) throws Exception {
        try {
            if (string2 != null) {
                return new DecimalFormat(string2).parse(string).intValue();
            }
        }
        catch (ParseException parseException) {
            return Integer.parseInt(string);
        }
        return null;
    }

    @Override
    public int getBmxDataWidth() {
        return 6;
    }

    @Override
    public byte getBmxIndex() {
        return 6;
    }
}

