/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype.eis;

import de.babtec.globals.knx.datatype.DataType;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DT_Eis14s
extends DataType<Integer> {
    public static final int MIN_VALUE = -128;
    public static final int MAX_VALUE = 127;

    public DT_Eis14s() {
        super(10000140, "EIS 14s (1 Byte signed)");
    }

    @Override
    public Double getDoubleValue(Integer n) {
        return n.doubleValue();
    }

    @Override
    public Integer getDataValue(Double d) {
        return d.intValue();
    }

    @Override
    public Integer getMaxValue() {
        return 127;
    }

    @Override
    public Integer getMinValue() {
        return -128;
    }

    @Override
    public Integer getValueInRange(Integer n, double d, double d2) {
        return super.getValueInRange(n, d, d2, -128, 127);
    }

    @Override
    public boolean isInRange(Integer n, double d, double d2) {
        return super.isInRange(n, d, d2, -128, 127);
    }

    @Override
    public Integer getValueInThisRange(Integer n, double d, double d2) {
        int n2 = (int)(-128.0 < d ? d : -128.0);
        int n3 = (int)(127.0 > d2 ? d2 : 127.0);
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    @Override
    public boolean isInThisRange(Integer n, double d, double d2) {
        return (double)n.intValue() >= Math.max(-128.0, d) && (double)n.intValue() <= Math.min(127.0, d2);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Integer n) {
        return new byte[]{n.byteValue()};
    }

    @Override
    public byte[] getData(Integer n, double d, double d2) {
        return this.getData((int)(((double)n.intValue() - d2) / d));
    }

    @Override
    public Integer getValue(byte[] byArray) {
        return byArray[0];
    }

    @Override
    public Integer getValue(byte[] byArray, double d, double d2) {
        return Double.valueOf((double)this.getValue(byArray).intValue() * d + d2).intValue();
    }

    @Override
    public String getValueAsString(Integer n) {
        return n.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%d";
    }

    @Override
    public String formatValue(Integer n, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(n);
    }

    @Override
    public Integer parseValue(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    public Integer parseValue(String string, String string2) throws Exception {
        try {
            if (string2 != null) {
                return new DecimalFormat(string2).parse(string).intValue();
            }
        }
        catch (ParseException parseException) {
            return Integer.parseInt(string);
        }
        return null;
    }

    @Override
    public int getBmxDataWidth() {
        return 5;
    }

    @Override
    public byte getBmxIndex() {
        return 11;
    }
}

