/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype.eis;

import de.babtec.globals.knx.datatype.DataType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DT_Eis3
extends DataType<Calendar> {
    public DT_Eis3() {
        super(10000030, "EIS 3 (3 Byte Time)");
    }

    @Override
    public Double getDoubleValue(Calendar calendar) {
        return new Double(calendar.getTimeInMillis());
    }

    @Override
    public Calendar getDataValue(Double d) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(d.longValue());
        return gregorianCalendar;
    }

    @Override
    public boolean getMinEnabled() {
        return false;
    }

    @Override
    public boolean getMaxEnabled() {
        return false;
    }

    @Override
    public boolean getOffsetEnabled() {
        return false;
    }

    @Override
    public boolean getFactorEnabled() {
        return false;
    }

    @Override
    public Calendar getMaxValue() {
        return null;
    }

    @Override
    public Calendar getMinValue() {
        return null;
    }

    @Override
    public Calendar getValueInRange(Calendar calendar, double d, double d2) {
        return calendar;
    }

    @Override
    public Calendar getValueInThisRange(Calendar calendar, double d, double d2) {
        return calendar;
    }

    @Override
    public boolean isInRange(Calendar calendar, double d, double d2) {
        return true;
    }

    @Override
    public boolean isInThisRange(Calendar calendar, double d, double d2) {
        return true;
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Calendar calendar) {
        byte[] byArray = new byte[]{(byte)calendar.get(11), (byte)calendar.get(12), (byte)calendar.get(13)};
        return byArray;
    }

    @Override
    public byte[] getData(Calendar calendar, double d, double d2) {
        return this.getData(calendar);
    }

    @Override
    public Calendar getValue(byte[] byArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        gregorianCalendar.set(11, byArray[0] & 0x1F);
        gregorianCalendar.set(12, byArray[1] & 0xFF);
        gregorianCalendar.set(13, byArray[2] & 0xFF);
        return gregorianCalendar;
    }

    @Override
    public Calendar getValue(byte[] byArray, double d, double d2) {
        return this.getValue(byArray);
    }

    @Override
    public String getValueAsString(Calendar calendar) {
        return DateFormat.getTimeInstance(3).format(calendar.getTime());
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%02d:%02d:%02d";
    }

    @Override
    public String formatValue(Calendar calendar, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    @Override
    public Calendar parseValue(String string) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Date date = simpleDateFormat.parse(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    @Override
    public Calendar parseValue(String string, String string2) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = simpleDateFormat.parse(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    @Override
    public int getBmxDataWidth() {
        return 7;
    }

    @Override
    public byte getBmxIndex() {
        return 7;
    }
}

