/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.matrix;

import de.babtec.matrix.DongleProtectReader;
import de.babtec.matrix.exceptions.DPParseException;
import de.babtec.matrix.exceptions.DPReadException;
import de.babtec.matrix.exceptions.DongleProtectException;
import java.util.HashMap;

public class DongleProtect {
    private static final int BLOCK_EMPTY = 0;
    private static final int RAW_DATA = 255;
    private HashMap<Integer, Integer> product_properties = new HashMap();
    private HashMap<Integer, byte[]> raw_data = new HashMap();
    private int version;
    private int company;
    private int sernr;
    private long expiresOn = 0L;
    private DongleProtectReader dpr;
    private boolean ignoreExpired = false;

    public void init(String[] stringArray) throws DPReadException, DPParseException, DongleProtectException {
        if (this.dpr == null) {
            this.dpr = new DongleProtectReader();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2.length != 2 || !stringArray2[0].equals("ignoreExpired")) continue;
                this.ignoreExpired = Boolean.parseBoolean(stringArray2[1]);
            }
        }
        try {
            this.parse(this.dpr.getDataBytes());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new DongleProtectException("Unknown Error");
        }
    }

    private void parse(byte[] byArray) throws DPParseException {
        this.version = 0;
        this.company = 0;
        this.sernr = 0;
        this.expiresOn = 0L;
        this.product_properties.clear();
        this.raw_data.clear();
        if (byArray.length != 60) {
            throw new DPParseException(0, "Invalid data length (!= 60)!");
        }
        int n = 0;
        this.version = byArray[n++] & 0xFF;
        this.company = byArray[n++] & 0xFF;
        this.sernr = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        n = 4;
        this.expiresOn = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        this.expiresOn *= 1000L;
        if (this.expiresOn < System.currentTimeMillis() && !this.ignoreExpired) {
            throw new DPParseException(1, "Stick expired");
        }
        for (int i = 3; i < 15; ++i) {
            int n2;
            int n3;
            n = i * 4;
            if (byArray[n] == 0) continue;
            if (byArray[n] == 255) {
                int n4 = ++n;
                n3 = byArray[n4];
                int n5 = ++n;
                ++n;
                n2 = byArray[n5];
                byte[] byArray2 = new byte[n3 * 4];
                for (int j = 0; j < n3; ++j) {
                    n = ++i * 4;
                    byArray2[j * 4] = byArray[n++];
                    byArray2[j * 4 + 1] = byArray[n++];
                    byArray2[j * 4 + 2] = byArray[n++];
                    byArray2[j * 4 + 3] = byArray[n++];
                }
                this.raw_data.put(n2, byArray2);
                continue;
            }
            n3 = byArray[n++];
            n2 = (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            this.product_properties.put(n3, n2);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getCompany() {
        return this.company;
    }

    public int getSerialNo() {
        return this.sernr;
    }

    public long getExpireDate() {
        return this.expiresOn;
    }

    public Integer[] getProducts() {
        return this.product_properties.keySet().toArray(new Integer[this.product_properties.size()]);
    }

    public boolean getProperty(int n, int n2) {
        Integer n3 = this.product_properties.get(n);
        if (n3 == null) {
            return false;
        }
        return (n3 & n2) > 0;
    }

    public byte[] getRawData(int n) {
        return this.raw_data.get(n);
    }
}

