/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool;

import de.babtec.globals.bmx.BMXPackets;
import de.babtec.matrix.DongleProtect;
import de.babtec.matrix.Utils;
import de.babtec.matrix.exceptions.DPParseException;
import de.babtec.matrix.exceptions.DPReadException;
import de.babtec.matrix.exceptions.DongleProtectException;
import de.babtec.updatetool.UpdateController;
import de.babtec.updatetool.UpdateListener;
import de.babtec.updatetool.discovery.Device;
import de.eibport.login.SecurityAdapter;
import de.eibport.login.model.EpSystemUser;
import de.eibport.login.model.EpSystemUserPool;
import de.eibport.net.bmx.BMXConnection;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import de.eibport.net.sftp.EibPortSftpException;
import de.eibport.net.sftp.FiProgressMonitor;
import de.eibport.net.sftp.KeyStorageBMX;
import de.eibport.net.sftp.SftpContainer;
import de.eibport.net.sftp.SftpTransfer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jdom.JDOMException;

public class Ep3UpdateController
extends UpdateController {
    public static final String FILE_UPDATE_FIRMWARE = "/update/fw_image.bin";
    public static final String FILE_UPDATE_PARAMS = "/update/params";
    public static final String FILE_UPDATE_READY = "/update/ready";

    public int startUpdate(Device device, String string, String string2, String string3, boolean bl) {
        EpDatagram epDatagram = device.getLastDatagram();
        String string4 = epDatagram.getBody().getPropertyString("bVersion");
        String[] stringArray = string4.split("-pre");
        int n = device.getLastDatagram().getBody().getPropertyInteger("bSernr");
        String string5 = new DecimalFormat("BT0000000000").format(n);
        int[] nArray = new int[4];
        if (stringArray.length == 2) {
            nArray[3] = Integer.parseInt(stringArray[1]);
        }
        stringArray = stringArray[0].split("\\.");
        nArray[0] = Integer.parseInt(stringArray[0]);
        nArray[1] = Integer.parseInt(stringArray[1]);
        nArray[2] = Integer.parseInt(stringArray[2]);
        if (Utils.isEibPortSernr(string5) && nArray[0] >= 3 || Utils.isIpcSernr(string5) && (nArray[0] == 1 && nArray[1] >= 6 || nArray[0] > 1)) {
            return this.startUpdateFw3(device, string, string2, string3, bl);
        }
        String string6 = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        int n2 = device.getSshPort();
        int n3 = epDatagram.getBody().getPropertyShort("bPortBmx") & 0xFFFF;
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.updateConnecting();
        }
        Object object = new BMXConnection(string6, n3, "UpdateTool", 0, "");
        KeyStorageBMX keyStorageBMX = new KeyStorageBMX((BMXConnection)object, 0, true);
        SftpContainer sftpContainer = new SftpContainer(string6, n2, keyStorageBMX);
        try {
            sftpContainer.init(string);
        }
        catch (EibPortSftpException eibPortSftpException) {
            for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                updateListener.updateError(eibPortSftpException.getMessage());
            }
            eibPortSftpException.printStackTrace();
            ((BMXConnection)object).closeSocket();
            object = null;
            return 2;
        }
        boolean bl2 = false;
        DongleProtect dongleProtect = new DongleProtect();
        try {
            dongleProtect.init(null);
            boolean bl3 = dongleProtect.getProperty(1, 4);
            boolean bl4 = dongleProtect.getProperty(2, 4);
            if (Utils.isEibPortSernr(string5) && bl3) {
                bl2 = true;
            }
            if (Utils.isIpcSernr(string5) && bl4) {
                bl2 = true;
            }
        }
        catch (DPReadException dPReadException) {
        }
        catch (DPParseException dPParseException) {
        }
        catch (DongleProtectException dongleProtectException) {
            // empty catch block
        }
        EpSystemUser epSystemUser = null;
        if (!bl2) {
            try {
                EpSystemUserPool epSystemUserPool = new EpSystemUserPool(sftpContainer.getFileInterface().readFromFile("/config/chroot/home/bt1/config/users.xml", true));
                epSystemUser = epSystemUserPool.getUser("admin", string2);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                bl2 = true;
            }
            catch (JDOMException jDOMException) {
                System.out.println(jDOMException.getMessage());
                bl2 = true;
            }
        }
        if (!bl2 && epSystemUser == null) {
            for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                updateListener.updateError("Wrong admin password");
            }
            return 3;
        }
        return this.performUpdate(device, (BMXConnection)object, sftpContainer, string3, bl);
    }

    private int startUpdateFw3(Device device, String string, String string2, String string3, boolean bl) {
        EpDatagram epDatagram = device.getLastDatagram();
        String string4 = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        int n = epDatagram.getBody().getPropertyShort("bPortHttp") & 0xFFFF;
        int n2 = device.getSshPort();
        int n3 = epDatagram.getBody().getPropertyShort("bPortBmx") & 0xFFFF;
        try {
            SecurityAdapter securityAdapter = new SecurityAdapter(new URL("http://" + string4 + ":" + n), 1);
            EpSystemUser epSystemUser = null;
            try {
                epSystemUser = securityAdapter.doSystemLogin("admin", string2.toCharArray());
            }
            catch (IOException iOException) {
                for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                    updateListener.updateError("The login is not available at the moment");
                }
                return 5;
            }
            if (epSystemUser == null) {
                for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                    updateListener.updateError("Wrong admin password");
                }
                return 3;
            }
            for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                updateListener.updateConnecting();
            }
            Object object = new BMXConnection(string4, n3, "UpdateTool", 1, epSystemUser.getLoginId());
            KeyStorageBMX keyStorageBMX = new KeyStorageBMX((BMXConnection)object, 0);
            SftpContainer sftpContainer = new SftpContainer(string4, n2, keyStorageBMX);
            try {
                sftpContainer.init(string);
            }
            catch (EibPortSftpException eibPortSftpException) {
                for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                    updateListener.updateError(eibPortSftpException.getMessage());
                }
                eibPortSftpException.printStackTrace();
                ((BMXConnection)object).closeSocket();
                object = null;
                return 2;
            }
            return this.performUpdate(device, (BMXConnection)object, sftpContainer, string3, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 13;
        }
    }

    private int performUpdate(Device device, BMXConnection bMXConnection, SftpContainer sftpContainer, String string, boolean bl) {
        Object object;
        Object object2;
        if (!bMXConnection.isConnected()) {
            bMXConnection.openSocket(true);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        bMXConnection.sendPacket(BMXPackets.constructSetSystem(1, simpleDateFormat.format(new Date())));
        bMXConnection.closeSocket();
        boolean bl2 = true;
        try {
            Object object4;
            Object object5;
            object2 = sftpContainer.getFileInterface().readFromFile("/update/bootstrap/settings", true);
            if (object2 != null) {
                bl2 = false;
                object5 = new BufferedReader(new InputStreamReader((InputStream)object2));
                while ((object4 = ((BufferedReader)object5).readLine()) != null) {
                    String[] object3;
                    if (!((String)object4).matches("version(\\w*)=(\\w*)\\d+") || (object3 = ((String)object4).split("=")).length != 2 || !object3[0].trim().matches("version")) continue;
                    int n = Integer.parseInt(object3[1].trim());
                    bl2 = n < 1;
                }
            }
            if (bl2) {
                ZipEntry zipEntry;
                System.out.println("installing bootstrap");
                object5 = this.getClass().getClassLoader().getResource("de/babtec/bootstrap_ep3/bootstrap_ver1");
                object4 = new ZipInputStream(((URL)object5).openStream());
                while ((zipEntry = ((ZipInputStream)object4).getNextEntry()) != null) {
                    GZIPInputStream gZIPInputStream;
                    if (zipEntry.getName().startsWith("bootstrap.tar.gz")) {
                        sftpContainer.getFileInterface().copy((InputStream)object4, "/update/" + zipEntry.getName());
                    }
                    if ("extract-bootstrap.gz".equals(zipEntry.getName())) {
                        gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(this.getBuffer((InputStream)object4)));
                        sftpContainer.getFileInterface().copy(gZIPInputStream, "/etc/init.d/extract-bootstrap");
                        sftpContainer.getFileInterface().setMode("/etc/init.d/extract-bootstrap", 493);
                    }
                    if (!"stop-bootlogd-single.gz".equals(zipEntry.getName())) continue;
                    gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(this.getBuffer((InputStream)object4)));
                    sftpContainer.getFileInterface().copy(gZIPInputStream, "/etc/init.d/stop-bootlogd-single");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 4;
        }
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.updateTransferring();
        }
        try {
            System.out.println("copying new firmware");
            object2 = (SftpTransfer)sftpContainer.getFileInterface();
            object = new FiProgressMonitor(){
                long max;
                long progress;

                @Override
                public void init(int n, String string, String string2, long l) {
                    System.out.println(n + " " + string + " " + string2 + " " + l);
                    this.max = l;
                    this.progress = 0L;
                    for (UpdateListener updateListener : (UpdateListener[])Ep3UpdateController.this.listener.getListeners(UpdateListener.class)) {
                        updateListener.updateUploadStarted(l);
                    }
                }

                @Override
                public void end() {
                    System.out.println("end");
                }

                @Override
                public boolean count(long l) {
                    this.progress += l;
                    for (UpdateListener updateListener : (UpdateListener[])Ep3UpdateController.this.listener.getListeners(UpdateListener.class)) {
                        updateListener.updateUploadProgress(this.progress, this.max);
                    }
                    return this.progress != this.max;
                }
            };
            File file = new File(string);
            ((FiProgressMonitor)object).init(0, string, FILE_UPDATE_FIRMWARE, file.length());
            ((SftpTransfer)object2).copy(new FileInputStream(string), FILE_UPDATE_FIRMWARE, (FiProgressMonitor)object);
            sftpContainer.getFileInterface().writeToFile(FILE_UPDATE_PARAMS, ("keep_ip=" + (bl ? "no\n" : "yes\n")).getBytes());
            sftpContainer.getFileInterface().writeToFile(FILE_UPDATE_READY, new byte[]{0});
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 14;
        }
        catch (IOException iOException) {
            return 13;
        }
        if (bl2) {
            System.out.println("rebooting eibPort");
            object2 = EpDatagram.getControlDatagram((short)64, (byte)1, (short)1);
            try {
                object = device.getLastDatagram().getHeader().getInetAddress("hIP").getHostAddress();
                int n = device.getLastDatagram().getBody().getPropertyShort("bPortUdp") & 0xFFFF;
                this.sendUDP((EpDatagram)object2, (String)object, n);
            }
            catch (IOException iOException) {
                System.err.println("Update finished but unable to restart eibPort. Manual reboot required!");
                return 13;
            }
        }
        System.out.println("update finished");
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.updateUploadFinished();
        }
        device.setIgnoreSeconds(120, true);
        return bl2 ? 12 : 11;
    }

    private byte[] getBuffer(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdatePresent(Device device) {
        if (device.isReachable() != 1) {
            return false;
        }
        try {
            System.out.println("refreshing update presence for " + device.getURL(""));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        EpDatagram epDatagram = device.getLastDatagram();
        String string = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        int n = epDatagram.getBody().getPropertyShort("bPortHttp") & 0xFFFF;
        InputStream inputStream = null;
        try {
            URL uRL = new URL("http://" + string + ":" + n + "/update_ready");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setReadTimeout(3000);
            inputStream = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            System.err.println(exception.getClass().getName() + " :: " + exception.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }
}

