/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool;

import de.babtec.matrix.Utils;
import de.babtec.updatetool.Ep3UpdateController;
import de.babtec.updatetool.UpdateListenerAdapter;
import de.babtec.updatetool.UpdateTool;
import de.babtec.updatetool.discovery.Device;
import de.babtec.updatetool.discovery.DeviceListener;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class Ep3UpdatePanel
extends JPanel {
    private CardLayout cards;
    private JPanel updateInputPanel;
    private JPanel updateProcessPanel;
    private Ep3UpdateController controller;
    private Device device;
    private JPasswordField inputSshString;
    private JTextField inputUsername;
    private JPasswordField inputPassword;
    private JCheckBox inputResetNetwork;
    private JTextField inputPath;
    private JTextField inputType;
    private JTextField inputVersion;
    private JTextArea outputStatus;
    private JButton choosePath;
    private JButton btnSubmit;
    private DeviceListener deviceListener;

    public Ep3UpdatePanel(Ep3UpdateController ep3UpdateController) {
        this.controller = ep3UpdateController;
        this.setBorder(BorderFactory.createTitledBorder(UpdateTool.messages.getString("UpdatePanel.title")));
        this.updateInputPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.updateInputPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("PreparationPanel.ssh_string")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputSshString = new JPasswordField();
        this.updateInputPanel.add((Component)this.inputSshString, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("PreparationPanel.username")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputUsername = new JTextField("admin");
        this.inputUsername.setEditable(false);
        this.updateInputPanel.add((Component)this.inputUsername, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("PreparationPanel.password")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputPassword = new JPasswordField();
        this.updateInputPanel.add((Component)this.inputPassword, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.file")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets.right = 0;
        this.inputPath = new JTextField();
        this.updateInputPanel.add((Component)this.inputPath, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 10;
        this.choosePath = new JButton("...");
        this.choosePath.setPreferredSize(new Dimension(this.choosePath.getPreferredSize().width, this.inputPath.getPreferredSize().height));
        this.choosePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Ep3UpdatePanel.this.chooseFile();
            }
        });
        this.updateInputPanel.add((Component)this.choosePath, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets.left = 10;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.type")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputType = new JTextField();
        this.inputType.setEditable(false);
        this.updateInputPanel.add((Component)this.inputType, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.version")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputVersion = new JTextField();
        this.inputVersion.setEditable(false);
        this.updateInputPanel.add((Component)this.inputVersion, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.reset_network")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputResetNetwork = new JCheckBox();
        this.updateInputPanel.add((Component)this.inputResetNetwork, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.bottom = 7;
        this.btnSubmit = new JButton(UpdateTool.messages.getString("UpdatePanel.btn_start"));
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Ep3UpdatePanel.this.startUpdate();
            }
        });
        this.updateInputPanel.add((Component)this.btnSubmit, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets.bottom = 0;
        this.updateInputPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.status")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 10;
        this.outputStatus = new JTextArea();
        this.outputStatus.setEditable(false);
        this.updateInputPanel.add((Component)new JScrollPane(this.outputStatus), gridBagConstraints);
        this.cards = new CardLayout();
        this.setLayout(this.cards);
        this.add((Component)this.updateInputPanel, "update_input");
        this.updateProcessPanel = new JPanel();
        this.updateProcessPanel.add(new JLabel(UpdateTool.messages.getString("UpdatePanel.message.epv3.in_progress")));
        this.add((Component)this.updateProcessPanel, "update_process");
        this.controller.addUpdateListener(new UpdateListenerAdapter(){
            int prevMB = -1;

            @Override
            public void updateUploadStarted(long l) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }

            @Override
            public void updateUploadProgress(final long l, final long l2) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = (int)Math.ceil(l / 1000000L);
                        if (n != prevMB) {
                            Ep3UpdatePanel.this.appendStatusMessage(n + "/" + (int)Math.ceil(l2 / 1000000L));
                            prevMB = n;
                        }
                    }
                });
            }

            @Override
            public void updateUploadFinished() {
                Ep3UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.upload_finished"));
            }

            @Override
            public void updateConnecting() {
                Ep3UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.connecting"));
            }

            @Override
            public void updateTransferring() {
                Ep3UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.uploading"));
            }

            @Override
            public void updateRebooting() {
                Ep3UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.installing"));
            }

            @Override
            public void updateError(String string) {
                Ep3UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.error") + string);
                Ep3UpdatePanel.this.setGuiEnabled(true);
            }
        });
        this.deviceListener = new DeviceListener(){

            @Override
            public void receivedNewBeacon(EpDatagram epDatagram) {
                Ep3UpdatePanel.this.updateGui();
            }

            @Override
            public void deviceUpdated(Device device, boolean bl) {
            }
        };
    }

    private void updateGui() {
        if (this.device.isReachable() == 1) {
            if (this.device.isInRescueMode() || this.device.isUpdatePresent()) {
                System.out.println("Ep3UpdatePanel.updateGui() rescue: " + this.device.isInRescueMode() + " || update: " + this.device.isUpdatePresent());
                this.cards.show(this, "update_process");
            } else {
                this.cards.show(this, "update_input");
            }
        } else {
            System.out.println("Ep3UpdatePanel.updateGui() device not reachable");
            this.cards.show(this, "update_process");
        }
    }

    private void appendStatusMessage(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ep3UpdatePanel.this.outputStatus.append(string + "\n");
            }
        });
    }

    private void chooseFile() {
        File file = new File(this.inputPath.getText());
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return UpdateTool.messages.getString("UpdatePanel.file_description");
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".bin");
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.inputPath.setText(string);
            this.checkFile(string, true);
        }
    }

    private void checkFile(String string, boolean bl) {
        String string2;
        this.btnSubmit.setEnabled(false);
        this.inputType.setText("");
        this.inputVersion.setText("");
        if (string.length() == 0) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.select_firmware"));
            this.btnSubmit.setEnabled(false);
            return;
        }
        if (bl) {
            int n = this.controller.compareMD5Checksum(string);
            switch (n) {
                case 1: {
                    JOptionPane.showMessageDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.success"), UpdateTool.messages.getString("UpdatePanel.title"), 1);
                    break;
                }
                case 4: {
                    JOptionPane.showMessageDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.fw_file_not_found"), UpdateTool.messages.getString("UpdatePanel.title"), 0);
                    return;
                }
                case 5: {
                    if (JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.chksum_unable_to_generate"), UpdateTool.messages.getString("UpdatePanel.title"), 0, 2) == 0) break;
                    return;
                }
                case 3: {
                    if (JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.chksum_file_not_found"), UpdateTool.messages.getString("UpdatePanel.title"), 0, 2) == 0) break;
                    return;
                }
                case 2: {
                    if (JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.chksum_error"), UpdateTool.messages.getString("UpdatePanel.title"), 0, 0) == 0) break;
                    return;
                }
            }
        }
        if ((string2 = this.controller.getTypeAndVersion(string)) == null) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.invalid_file"));
            return;
        }
        String string3 = "type=\"(.*?)\".*?version=\"(.*?)\"";
        Pattern pattern = Pattern.compile(string3, 40);
        Matcher matcher = pattern.matcher(string2);
        if (!matcher.matches()) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.invalid_firmware"));
            return;
        }
        String string4 = matcher.group(1);
        String string5 = matcher.group(2);
        this.inputType.setText("ipc3".equals(string4) ? "ipc" : string4);
        this.inputVersion.setText(string5);
        int n = this.device.getLastDatagram().getBody().getPropertyInteger("bSernr");
        String string6 = new DecimalFormat("BT0000000000").format(n);
        if (Utils.isEibPortSernr(string6) && string6.endsWith("30") && !"epv3".equals(string4)) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.no_ep3_firmware"));
            return;
        }
        if (Utils.isIpcSernr(string6) && string6.endsWith("30") && !"ipc3".equals(string4)) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.no_ipc3_firmware"));
            return;
        }
        this.btnSubmit.setEnabled(true);
        this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.ready"));
    }

    private void startUpdate() {
        int n = JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.confirm_backup_done"), "Firmware Update", 0);
        if (n == 1) {
            return;
        }
        this.setGuiEnabled(false);
        new Thread(){

            @Override
            public void run() {
                final int n = Ep3UpdatePanel.this.controller.startUpdate(Ep3UpdatePanel.this.device, new String(Ep3UpdatePanel.this.inputSshString.getPassword()), new String(Ep3UpdatePanel.this.inputPassword.getPassword()), Ep3UpdatePanel.this.inputPath.getText(), Ep3UpdatePanel.this.inputResetNetwork.isSelected());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ep3UpdatePanel.this.updateFinished(n);
                    }
                });
            }
        }.start();
    }

    private void setGuiEnabled(boolean bl) {
        this.inputSshString.setEnabled(bl);
        this.inputPassword.setEnabled(bl);
        this.inputPath.setEnabled(bl);
        this.btnSubmit.setEnabled(bl);
        this.choosePath.setEnabled(bl);
        this.inputResetNetwork.setEnabled(bl);
    }

    private void updateFinished(int n) {
        String string = "Unknown error";
        int n2 = 1;
        switch (n) {
            case 2: {
                int n3 = this.device.getLastDatagram().getBody().getPropertyShort("bPortSsh") & 0xFFFF;
                string = UpdateTool.messages.getString("PreparationPanel.message.wrong_string").replace("%ssh_port%", Integer.toString(n3));
                n2 = 0;
                this.setGuiEnabled(true);
                break;
            }
            case 5: {
                string = UpdateTool.messages.getString("PreparationPanel.message.no_login_available");
                n2 = 0;
                this.setGuiEnabled(true);
                break;
            }
            case 3: {
                string = UpdateTool.messages.getString("PreparationPanel.message.wrong_passwd");
                n2 = 0;
                this.setGuiEnabled(true);
                break;
            }
            case 13: {
                short s = this.device.getLastDatagram().getBody().getPropertyShort("bPortSsh");
                string = UpdateTool.messages.getString("UpdatePanel.message.wrong_string").replace("%ssh_port%", Integer.toString(s));
                n2 = 0;
                this.setGuiEnabled(true);
                break;
            }
            case 14: {
                string = UpdateTool.messages.getString("UpdatePanel.message.file_not_found").replace("%path%", this.inputPath.getText());
                n2 = 0;
                this.setGuiEnabled(true);
                break;
            }
            case 11: {
                string = UpdateTool.messages.getString("UpdatePanel.message.epv3.update_success");
                n2 = 1;
                this.cards.show(this, "update_process");
                break;
            }
            case 12: {
                string = UpdateTool.messages.getString("UpdatePanel.message.epv3.bootstrap_and_update_success");
                n2 = 1;
                this.cards.show(this, "update_process");
            }
        }
        JOptionPane.showMessageDialog(this, string, UpdateTool.messages.getString("UpdatePanel.title"), n2);
    }

    public void setDevice(Device device) {
        if (device != null && this.device != null && this.device.equals(device)) {
            return;
        }
        if (this.device != null) {
            device.removeDeviceListener(this.deviceListener);
        }
        this.device = device;
        this.outputStatus.setText("");
        boolean bl = device != null && device.isActive();
        this.choosePath.setEnabled(bl);
        this.inputPath.setEnabled(bl);
        this.btnSubmit.setEnabled(bl);
        this.inputSshString.setEnabled(bl);
        this.inputPassword.setEnabled(bl);
        this.inputPath.setEnabled(bl);
        if (device != null) {
            this.checkFile(this.inputPath.getText(), false);
            device.addDeviceListener(this.deviceListener);
        }
        this.updateGui();
    }

    public Device getDevice() {
        return this.device;
    }
}

