/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool.discovery;

import de.babtec.updatetool.BrowserLauncher;
import de.babtec.updatetool.UpdateController;
import de.babtec.updatetool.UpdateTool;
import de.babtec.updatetool.UpdateToolPanel;
import de.babtec.updatetool.discovery.Device;
import de.babtec.updatetool.discovery.DeviceListener;
import de.eibport.net.mcast.DatagramListener;
import de.eibport.net.mcast.MulticastThread;
import de.eibport.net.mcast.packets.v1.Beacon;
import de.eibport.net.mcast.packets.v2.BodyBeaconEP;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import de.eibport.net.mcast.packets.v2.EpDatagramBody;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiscoveryPanel
extends JPanel {
    private MulticastThread mct;
    private UpdateToolPanel utp;
    private HashMap<String, Device> serialIndex = new HashMap();
    private Icon iconRescue;
    private JList deviceList;
    private DefaultListModel dlm;
    private JTextField infoIP;
    private JTextField infoSerNr;
    private JTextField infoFwVersion;
    private JTextField infoHTTP;
    private JTextField infoSSH;
    private JTextField infoBMXTCP;
    private JTextField infoBMXUDP;
    private JButton btnLedTest;
    private JButton btnOpenInBrowser;

    public DiscoveryPanel(final UpdateToolPanel updateToolPanel, final UpdateController updateController) {
        this.utp = updateToolPanel;
        this.setBorder(BorderFactory.createTitledBorder(UpdateTool.messages.getString("DiscoveryPanel.title")));
        this.dlm = new DefaultListModel();
        this.deviceList = new JList(this.dlm);
        this.deviceList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object.equals(DiscoveryPanel.this.deviceList.getSelectedValue()) && component instanceof JLabel) {
                    ((JLabel)component).setBorder(BorderFactory.createLineBorder(Color.RED, 2));
                }
                if (object instanceof Beacon) {
                    component.setBackground(new Color(255, 148, 148));
                }
                if (object instanceof Device) {
                    Device device = (Device)object;
                    if (!device.isActive()) {
                        component.setBackground(new Color(148, 148, 255));
                    } else {
                        switch (device.isReachable()) {
                            case 1: {
                                component.setBackground(new Color(148, 255, 148));
                                break;
                            }
                            case 0: {
                                component.setBackground(new Color(255, 255, 148));
                                break;
                            }
                            case 2: {
                                component.setBackground(new Color(192, 192, 192));
                            }
                        }
                    }
                    if (component instanceof JLabel) {
                        switch (device.getType()) {
                            case 3: {
                                if (!device.isInRescueMode() && !device.isUpdatePresent()) break;
                                component.setBackground(new Color(148, 148, 255));
                                break;
                            }
                            case 2: {
                                if (!device.isInRescueMode()) break;
                                ((JLabel)component).setIcon(DiscoveryPanel.this.iconRescue);
                            }
                        }
                    }
                }
                return component;
            }
        });
        this.deviceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                DiscoveryPanel.this.btnLedTest.setEnabled(false);
                DiscoveryPanel.this.btnOpenInBrowser.setEnabled(false);
                DiscoveryPanel.this.clearInfo();
                Object e = DiscoveryPanel.this.deviceList.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (e instanceof Device) {
                    if (((Device)e).isActive()) {
                        DiscoveryPanel.this.showInfo((Device)e);
                        updateToolPanel.deviceSelected((Device)e);
                        DiscoveryPanel.this.btnLedTest.setEnabled(!((Device)e).isInRescueMode());
                        if (!((Device)e).isInRescueMode() && ((Device)e).isReachable() == 1) {
                            DiscoveryPanel.this.btnOpenInBrowser.setEnabled(true);
                        }
                    } else {
                        updateToolPanel.deviceSelected(null);
                        JOptionPane.showMessageDialog(DiscoveryPanel.this, UpdateTool.messages.getString("DiscoveryPanel.unavailable"));
                    }
                }
            }
        });
        this.iconRescue = new ImageIcon(this.getClass().getResource("/de/babtec/updatetool/rescue.png"));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.deviceList), "Center");
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        jPanel.setLayout(new GridLayout(0, 2, 0, 5));
        jPanel.add(new JLabel(UpdateTool.messages.getString("DiscoveryPanel.ip_address")));
        this.infoIP = new JTextField();
        this.infoIP.setEditable(false);
        jPanel.add(this.infoIP);
        jPanel.add(new JLabel(UpdateTool.messages.getString("DiscoveryPanel.serial_nr")));
        this.infoSerNr = new JTextField();
        this.infoSerNr.setEditable(false);
        jPanel.add(this.infoSerNr);
        jPanel.add(new JLabel(UpdateTool.messages.getString("DiscoveryPanel.fw_version")));
        this.infoFwVersion = new JTextField();
        this.infoFwVersion.setEditable(false);
        jPanel.add(this.infoFwVersion);
        jPanel.add(new JLabel(UpdateTool.messages.getString("DiscoveryPanel.port_http")));
        this.infoHTTP = new JTextField();
        this.infoHTTP.setEditable(false);
        jPanel.add(this.infoHTTP);
        jPanel.add(new JLabel(UpdateTool.messages.getString("DiscoveryPanel.port_ssh")));
        this.infoSSH = new JTextField();
        this.infoSSH.setEditable(false);
        jPanel.add(this.infoSSH);
        jPanel.add(new JLabel(UpdateTool.messages.getString("DiscoveryPanel.port_bmx_tcp")));
        this.infoBMXTCP = new JTextField();
        this.infoBMXTCP.setEditable(false);
        jPanel.add(this.infoBMXTCP);
        jPanel.add(new JLabel(UpdateTool.messages.getString("DiscoveryPanel.port_bmx_udp")));
        this.infoBMXUDP = new JTextField();
        this.infoBMXUDP.setEditable(false);
        jPanel.add(this.infoBMXUDP);
        this.btnLedTest = new JButton(UpdateTool.messages.getString("DiscoveryPanel.led_test"));
        this.btnLedTest.setPreferredSize(new Dimension(this.btnLedTest.getPreferredSize().width, this.infoBMXTCP.getPreferredSize().height));
        this.btnLedTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object e = DiscoveryPanel.this.deviceList.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (e instanceof Device && ((Device)e).isActive()) {
                    try {
                        updateController.startLedTest((Device)e);
                        JOptionPane.showMessageDialog(DiscoveryPanel.this, UpdateTool.messages.getString("DiscoveryPanel.led_test.success"));
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(DiscoveryPanel.this, UpdateTool.messages.getString("DiscoveryPanel.led_test.failed"));
                    }
                }
            }
        });
        jPanel.add(this.btnLedTest);
        this.btnOpenInBrowser = new JButton(UpdateTool.messages.getString("DiscoveryPanel.open_in_browser"));
        this.btnOpenInBrowser.setPreferredSize(new Dimension(this.btnOpenInBrowser.getPreferredSize().width, this.infoBMXTCP.getPreferredSize().height));
        jPanel.add(this.btnOpenInBrowser);
        this.btnOpenInBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Device device;
                Object e = DiscoveryPanel.this.deviceList.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (e instanceof Device && (device = (Device)e).isActive() && device.isReachable() == 1) {
                    String string = device.getLastDatagram().getHeader().getInetAddress("hIP").getHostAddress();
                    int n = device.getLastDatagram().getBody().getPropertyShort("bPortHttp") & 0xFFFF;
                    try {
                        BrowserLauncher.openURL("http://" + string + ":" + n);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        this.btnLedTest.setEnabled(false);
        this.btnOpenInBrowser.setEnabled(false);
        this.startDiscovery();
    }

    private void startDiscovery() {
        this.mct = new MulticastThread(MulticastThread.DEFAULT_GROUP_ADDRESS, 1735, 512, true);
        this.mct.addListener(new DatagramListener(){

            @Override
            public void receivedBeacon(final EpDatagram epDatagram) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiscoveryPanel.this.addDatagramToList(epDatagram);
                    }
                });
            }

            @Override
            public void receivedBeacon(final Beacon beacon) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiscoveryPanel.this.dlm.addElement(beacon);
                    }
                });
            }

            @Override
            public void receivedConfig(EpDatagram epDatagram, InetAddress inetAddress, int n) {
            }

            @Override
            public void receivedJSON(EpDatagram epDatagram, InetAddress inetAddress, int n) {
            }
        });
        this.mct.start();
        this.mct.sendBytes(EpDatagram.getDiscoverDatagram((short)512).getBytes());
        new DeviceRefresher().start();
    }

    private void clearInfo() {
        this.infoIP.setText("");
        this.infoSerNr.setText("");
        this.infoFwVersion.setText("");
        this.infoHTTP.setText("");
        this.infoSSH.setText("");
        this.infoBMXTCP.setText("");
        this.infoBMXUDP.setText("");
    }

    private void showInfo(Device device) {
        EpDatagram epDatagram = device.getLastDatagram();
        this.infoIP.setText(epDatagram.getHeader().getInetAddress("hIP").getHostAddress());
        EpDatagramBody epDatagramBody = epDatagram.getBody();
        int n = epDatagramBody.getPropertyInteger("bSernr");
        this.infoSerNr.setText(new DecimalFormat("BT0000000000").format(n));
        if (epDatagramBody instanceof BodyBeaconEP && !epDatagram.isInRescueMode()) {
            this.infoFwVersion.setText(((BodyBeaconEP)epDatagramBody).getCompleteVersion());
        } else {
            this.infoFwVersion.setText("");
        }
        this.infoHTTP.setText(Integer.toString(epDatagramBody.getPropertyShort("bPortHttp") & 0xFFFF));
        this.infoSSH.setText(Integer.toString(device.getSshPort()));
        this.infoBMXTCP.setText(Integer.toString(epDatagramBody.getPropertyShort("bPortBmx") & 0xFFFF));
        this.infoBMXUDP.setText(Integer.toString(epDatagramBody.getPropertyShort("bPortUdp") & 0xFFFF));
    }

    private void addDatagramToList(EpDatagram epDatagram) {
        String string = ((BodyBeaconEP)epDatagram.getBody()).getSerialNrString();
        if (!this.serialIndex.containsKey(string)) {
            Device device = new Device(epDatagram);
            device.addDeviceListener(new DeviceListener(){

                @Override
                public void deviceUpdated(Device device, boolean bl) {
                    if (device.equals(DiscoveryPanel.this.deviceList.getSelectedValue())) {
                        if (bl) {
                            DiscoveryPanel.this.deviceList.clearSelection();
                            DiscoveryPanel.this.clearInfo();
                            DiscoveryPanel.this.utp.deviceSelected(null);
                        } else {
                            DiscoveryPanel.this.showInfo(device);
                            DiscoveryPanel.this.utp.deviceSelected(device);
                        }
                        DiscoveryPanel.this.btnLedTest.setEnabled(!device.isInRescueMode() && device.isActive());
                        DiscoveryPanel.this.btnOpenInBrowser.setEnabled(!device.isInRescueMode() && device.isActive() && device.isReachable() == 1);
                    }
                    DiscoveryPanel.this.deviceList.repaint();
                }

                @Override
                public void receivedNewBeacon(EpDatagram epDatagram) {
                }
            });
            this.dlm.addElement(device);
            this.serialIndex.put(string, device);
        } else {
            this.serialIndex.get(string).setNewDatagram(epDatagram);
            this.deviceList.repaint();
        }
    }

    class DeviceRefresher
    extends Thread {
        public DeviceRefresher() {
            super("UpdateTool DeviceRefresher");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                for (Device device : DiscoveryPanel.this.serialIndex.values()) {
                    device.testTimeout(35);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

