/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components;

import de.babtec.globals.BTColors;
import de.babtec.globals.knx.address.EIBAddress2;
import de.babtec.globals.knx.address.EIBAddressObject2;
import java.awt.Color;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MyTextField
extends JTextField {
    public static final int DEFAULT = 0;
    public static final int EIBADDRESSOBJECT = 1;
    public static final int EIBADDRESS = 7;
    public static final int INTEGER = 2;
    public static final int DOUBLE = 3;
    public static final int URL = 4;
    public static final int EMAIL = 5;
    public static final int FORMAT = 6;
    public static final int NOT_EMPTY = 8;
    public static final int REGEXP = 9;
    public static final int PHONE = 10;
    private int maxLength = 0;
    protected int type;
    private String regexp = ".*";

    public MyTextField(String string, String string2) {
        this.type = 9;
        this.setDocument(new MyPlainDocument());
        this.setRegexp(string);
        this.setText(string2);
    }

    public MyTextField(int n) {
        this.type = n;
        this.setDocument(new MyPlainDocument());
    }

    public MyTextField(String string, int n) {
        this.type = n;
        this.setDocument(new MyPlainDocument());
        this.setText(string);
    }

    public MyTextField(int n, int n2) {
        this.type = n;
        this.maxLength = n2;
        this.setDocument(new MyPlainDocument());
    }

    public MyTextField(String string, int n, int n2) {
        this.type = n;
        this.maxLength = n2;
        this.setDocument(new MyPlainDocument());
        this.setText(string);
    }

    public MyTextField() {
        this.setDocument(new MyPlainDocument());
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getType() {
        return this.type;
    }

    public void setRegexp(String string) {
        this.regexp = string;
        if (this.type == 9) {
            ((MyPlainDocument)this.getDocument()).setBackgroundColor(Pattern.matches(string, this.getText()));
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (this.type == 9) {
            ((MyPlainDocument)this.getDocument()).setBackgroundColor(Pattern.matches(this.regexp, this.getText()));
        }
    }

    @Override
    public boolean isValid() {
        if (this.type == 9) {
            return Pattern.matches(this.regexp, this.getText());
        }
        if (this.type == 7) {
            return Pattern.matches("\\A\\d{1,2}\\/\\d{1,4}\\Z", this.getText()) || Pattern.matches("\\A\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}\\Z", this.getText());
        }
        return false;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        ((MyPlainDocument)this.getDocument()).setBackgroundColor();
        super.setEnabled(bl);
    }

    class MyPlainDocument
    extends PlainDocument {
        private static final String regexp_AddrObj2 = "\\A\\d{1,2}\\/\\d{1,4}(\\((\\d{1,2}\\/\\d{1,4},){0,3}\\d{1,2}\\/\\d{1,4}\\)){0,1}\\Z";
        private static final String regexp_AddrObj3 = "\\A\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}(\\((\\d{1,2}\\/\\d{1,2}\\/\\d{1,3},){0,3}\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}\\)){0,1}\\Z";
        private static final String regexp_Addr2 = "\\A\\d{1,2}\\/\\d{1,4}\\Z";
        private static final String regexp_Addr3 = "\\A\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}\\Z";
        private static final String regexp_format = "\\A([#]{1,}|[0]{1,}|[#]*[0]{1,}|[#]{1,}[0]*)([.]{1}([#]{1,}|[0]{1,}|[0]{1,}[#]*|[0]*[#]{1,}))?\\Z";
        private final Color COLOR_ERROR = BTColors.COLOR_RED;
        private final Color COLOR_OK = BTColors.COLOR_GREEN;
        private final Color COLOR_EMPTY = BTColors.COLOR_YELLOW;

        public MyPlainDocument() {
            if (MyTextField.this.type == 1 || MyTextField.this.type == 7 || MyTextField.this.type == 8) {
                MyTextField.this.setBackground(this.COLOR_EMPTY);
            }
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException, IndexOutOfBoundsException {
            if (string.length() != 0 && (MyTextField.this.maxLength == 0 || this.getLength() + string.length() <= MyTextField.this.maxLength)) {
                switch (MyTextField.this.type) {
                    case 1: {
                        string = string.replace(' ', '/');
                        break;
                    }
                    case 7: {
                        string = string.replace(' ', '/');
                        break;
                    }
                    case 2: {
                        if (Character.isDigit(string.charAt(0))) break;
                        return;
                    }
                    case 3: {
                        string = string.replace(',', '.');
                        if (Character.isDigit(string.charAt(0)) || string.charAt(0) == '.') break;
                        return;
                    }
                    case 10: {
                        if (Character.isDigit(string.charAt(0)) || string.charAt(0) == '+') break;
                        return;
                    }
                }
                super.insertString(n, string, attributeSet);
                if (MyTextField.this.type == 1 || MyTextField.this.type == 7 || MyTextField.this.type == 8) {
                    this.setBackgroundColor();
                }
                if (MyTextField.this.type == 6) {
                    this.setBackgroundColor(Pattern.matches(regexp_format, this.getText(0, this.getLength())));
                }
                if (MyTextField.this.type == 9) {
                    this.setBackgroundColor(Pattern.matches(MyTextField.this.regexp, this.getText(0, this.getLength())));
                }
            }
        }

        @Override
        protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            super.removeUpdate(defaultDocumentEvent);
            if (MyTextField.this.type == 1 || MyTextField.this.type == 7 || MyTextField.this.type == 8) {
                if (this.getLength() == 0) {
                    MyTextField.this.setBackground(this.COLOR_EMPTY);
                } else {
                    this.setBackgroundColor();
                }
            } else if (MyTextField.this.type == 6) {
                try {
                    this.setBackgroundColor(Pattern.matches(regexp_format, this.getText(0, this.getLength())));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            } else if (MyTextField.this.type == 9) {
                try {
                    this.setBackgroundColor(Pattern.matches(MyTextField.this.regexp, this.getText(0, this.getLength())));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        protected void setBackgroundColor() {
            try {
                switch (MyTextField.this.type) {
                    case 1: {
                        if (this.getLength() == 0) {
                            MyTextField.this.setBackground(this.COLOR_EMPTY);
                            break;
                        }
                        this.setBackgroundColor(EIBAddressObject2.isValidAddressObjectString(this.getText(0, this.getLength())));
                        break;
                    }
                    case 7: {
                        if (this.getLength() == 0) {
                            MyTextField.this.setBackground(this.COLOR_EMPTY);
                            break;
                        }
                        this.setBackgroundColor(EIBAddress2.isValid(this.getText(0, this.getLength())));
                        break;
                    }
                    case 8: {
                        if (this.getLength() == 0) {
                            MyTextField.this.setBackground(this.COLOR_EMPTY);
                            break;
                        }
                        MyTextField.this.setBackground(this.COLOR_OK);
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Unable to set Backgroundcolor");
            }
        }

        private void setBackgroundColor(boolean bl) {
            if (bl) {
                MyTextField.this.setBackground(this.COLOR_OK);
            } else {
                MyTextField.this.setBackground(this.COLOR_ERROR);
            }
        }
    }
}

