/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield;

import de.babtec.globals.esf.ESFData;
import de.babtec.globals.esf.ESFElement;
import de.babtec.globals.esf.EsfDataListener;
import de.babtec.globals.esf.MainGroup;
import de.babtec.globals.esf.MiddleGroup;
import de.babtec.globals.knx.datatype.DataType;
import de.eibport.components.addressfield.EsfTreeTableModel;
import de.eibport.components.jtreetable.JTreeTable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class ESFTreeTable
extends JTreeTable {
    private ESFData data;
    private EsfTreeTableModel ttm;

    public ESFTreeTable(ESFData eSFData) {
        this.data = eSFData;
        this.ttm = new EsfTreeTableModel(eSFData);
        super.init(this.ttm);
        this.getTree().setRootVisible(false);
        this.init();
    }

    public ESFElement getSelectedObject() {
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null && treePath.getLastPathComponent() instanceof ESFElement) {
            return (ESFElement)treePath.getLastPathComponent();
        }
        return null;
    }

    public void expandPath(TreePath treePath) {
        this.getTree().expandPath(treePath);
        Object object = treePath.getLastPathComponent();
        for (int i = 0; i < this.getTree().getModel().getChildCount(object); ++i) {
            this.expandPath(treePath.pathByAddingChild(this.getTree().getModel().getChild(object, i)));
        }
    }

    private void init() {
        this.data.addEsfDataListener(new EsfDataListener(){

            @Override
            public void esfDataChanged() {
                ESFTreeTable.this.storeExpandedPaths();
                ESFTreeTable.this.ttm.reloadModel();
                ESFTreeTable.this.restoreExpandedPaths();
            }

            @Override
            public void esfElementAdded(ESFElement eSFElement) {
                ESFTreeTable.this.storeExpandedPaths();
                ESFTreeTable.this.ttm.reloadModel();
                ESFTreeTable.this.restoreExpandedPaths();
            }

            @Override
            public void esfElementChanged(ESFElement eSFElement) {
                ESFTreeTable.this.storeExpandedPaths();
                ESFTreeTable.this.ttm.reloadModel();
                ESFTreeTable.this.restoreExpandedPaths();
            }

            @Override
            public void esfElementRemoved(ESFElement eSFElement) {
                ESFTreeTable.this.storeExpandedPaths();
                ESFTreeTable.this.ttm.reloadModel();
                ESFTreeTable.this.restoreExpandedPaths();
            }

            @Override
            public void esfMainGroupChanged(MainGroup mainGroup) {
                ESFTreeTable.this.storeExpandedPaths();
                ESFTreeTable.this.ttm.reloadModel();
                ESFTreeTable.this.restoreExpandedPaths();
            }

            @Override
            public void esfMiddleGroupChanged(MiddleGroup middleGroup) {
                ESFTreeTable.this.storeExpandedPaths();
                ESFTreeTable.this.ttm.reloadModel();
                ESFTreeTable.this.restoreExpandedPaths();
            }
        });
        this.getColumnModel().getColumn(0).setPreferredWidth(280);
        TableColumn tableColumn = this.getColumnModel().getColumn(2);
        DataType<?>[] dataTypeArray = DataType.getDataTypes();
        Arrays.sort(dataTypeArray, new Comparator<DataType>(){

            @Override
            public int compare(DataType dataType, DataType dataType2) {
                return dataType.toString().compareTo(dataType2.toString());
            }
        });
        final JComboBox jComboBox = new JComboBox(dataTypeArray);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TreePath treePath = ESFTreeTable.this.getTree().getSelectionPath();
                if (treePath != null && treePath.getLastPathComponent() instanceof ESFElement) {
                    ESFElement eSFElement = (ESFElement)treePath.getLastPathComponent();
                    int n = ESFTreeTable.this.getSelectedRow();
                    if (itemEvent.getStateChange() == 1 && n != -1 && ESFTreeTable.this.isEditing()) {
                        DataType dataType = (DataType)jComboBox.getSelectedItem();
                        eSFElement.setDataType(dataType);
                    }
                }
            }
        });
    }
}

