/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield;

import de.babtec.globals.deprecated.eibaddress.IllegalAddressException;
import de.babtec.globals.esf.ESFAddressObject;
import de.babtec.globals.esf.ESFData;
import de.eibport.components.MyTextField;
import de.eibport.components.addressfield.JAddressDialog;
import de.eibport.net.sftp.SftpContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JAddressSelector
extends JPanel {
    public static int ADDRESSLAYERS = 2;
    public static String string_choose_address = "Choose EIB-Address";
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private MyTextField addressField = new MyTextField(1);
    private String description;
    private JToggleButton addressToggle = new JToggleButton();
    private JButton addressSelect = new JButton();
    private JAddressDialog addressDialog;
    private ImageIcon iconToggle;
    private ImageIcon iconTogglePressed;
    private ESFData esfData;
    private int type;
    private SftpContainer sftpContainer;

    public JAddressSelector(ESFData eSFData, int n, SftpContainer sftpContainer) {
        this.esfData = eSFData;
        this.type = n;
        this.sftpContainer = sftpContainer;
        this.createComponents();
    }

    public void createComponents() {
        this.iconToggle = new ImageIcon(this.getClass().getResource("btn_toggle.gif"));
        this.iconTogglePressed = new ImageIcon(this.getClass().getResource("btn_toggleP.gif"));
        this.addressToggle.setIcon(this.iconToggle);
        this.addressToggle.setToolTipText("");
        this.addressToggle.setContentAreaFilled(false);
        this.addressToggle.setMargin(new Insets(0, 0, 0, 0));
        this.addressToggle.setPreferredSize(new Dimension(this.iconToggle.getIconWidth(), this.iconToggle.getIconHeight()));
        this.addressToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JAddressSelector.this.addressToggle.isSelected()) {
                    JAddressSelector.this.addressToggle.setIcon(JAddressSelector.this.iconTogglePressed);
                    JAddressSelector.this.addressField.setEditable(false);
                } else {
                    JAddressSelector.this.addressToggle.setIcon(JAddressSelector.this.iconToggle);
                    JAddressSelector.this.addressField.setEditable(true);
                }
            }
        });
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("btn_esf.gif"));
        this.addressSelect.setIcon(imageIcon);
        this.addressSelect.setToolTipText(string_choose_address);
        this.addressSelect.setContentAreaFilled(false);
        this.addressSelect.setMargin(new Insets(0, 0, 0, 0));
        this.addressSelect.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.addressSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JAddressSelector.this.addressDialog = JAddressDialog.getAddressDialog(new ESFAddressObject(JAddressSelector.this.esfData, JAddressSelector.this.type, JAddressSelector.this.addressField.getText()), JAddressSelector.this.esfData, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ESFAddressObject eSFAddressObject = JAddressSelector.this.addressDialog.getCurrentAddresses();
                            if (eSFAddressObject != null) {
                                JAddressSelector.this.addressField.setText(eSFAddressObject.getAddressObjectAsString());
                                if (JAddressSelector.this.esfData != null) {
                                    JAddressSelector.this.setToolTipText(eSFAddressObject.getDescription());
                                }
                            }
                            JAddressSelector.this.addressDialog.setVisible(false);
                        }
                    }, JAddressSelector.this.sftpContainer);
                    JAddressSelector.this.addressDialog.setVisible(true);
                }
                catch (IllegalAddressException illegalAddressException) {
                    // empty catch block
                }
            }
        });
        this.addressField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    if (JAddressSelector.this.esfData != null) {
                        JAddressSelector.this.setToolTipText(new ESFAddressObject(JAddressSelector.this.esfData, JAddressSelector.this.type, JAddressSelector.this.addressField.getText()).getDescription());
                    }
                }
                catch (IllegalAddressException illegalAddressException) {
                    // empty catch block
                }
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.addressField, "Center");
        this.add((Component)this.addressSelect, "East");
    }

    public void setType(int n) {
        this.type = n;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void centerComponent(Component component, Component component2) {
        Point point = component2.getLocation();
        Dimension dimension = component2.getSize();
        Dimension dimension2 = component.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width / 2 - dimension2.width / 2 + point.x;
        int n2 = dimension.height / 2 - dimension2.height / 2 + point.y;
        if (n < 0) {
            n = 0;
        }
        if (n > dimension3.width) {
            n = dimension3.width;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > dimension3.height) {
            n2 = dimension3.height;
        }
        component.setLocation(n, n2);
    }

    @Override
    public void setVisible(boolean bl) {
        this.addressField.setVisible(bl);
        this.addressSelect.setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.addressField.setEnabled(bl);
        this.addressSelect.setEnabled(bl);
    }

    public void setAddress(String string) {
        this.addressField.setText(string);
        try {
            if (this.esfData != null) {
                this.setToolTipText(new ESFAddressObject(this.esfData, this.type, string).getDescription());
            }
        }
        catch (IllegalAddressException illegalAddressException) {
            // empty catch block
        }
    }

    public String getAddress() {
        return this.addressField.getText();
    }

    @Override
    public void setToolTipText(String string) {
        if (string == "") {
            this.addressField.setToolTipText(null);
        } else {
            this.addressField.setToolTipText(string);
        }
        this.description = string;
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public String getDescription() {
        return this.description;
    }
}

