/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.localization;

import de.eibport.components.JButtonBar;
import de.eibport.components.localization.LocalizationTools;
import de.eibport.components.ssh.JSshUnlockButton;
import de.eibport.net.sftp.SftpContainer;
import de.eibport.net.sftp.SftpContainerListener;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LocalizationUpload
extends JDialog {
    public static String string_title = "Localization Upload";
    public static String string_lang_available = "Available Languages";
    public static String string_lang_upload = "Upload Language";
    public static String string_btn_download = "Download";
    public static String string_btn_delete = "Delete";
    public static String string_btn_upload = "Upload...";
    public static String string_btn_do_upload = "Upload";
    public static String string_btn_unlock = "Unlock";
    public static String string_btn_ok = "OK";
    public static String string_deletion_success = "Deletion successful.";
    public static String string_deletion_invalid = "Unable to delete this item.";
    public static String string_deletion_error = "An error occurred while deleting this item.";
    public static String string_files = "Localization Files";
    public static String string_upload_success = "Upload finished. Please restart the editor to apply the new language.";
    public static String string_upload_invalid = "Unable to upload this file.";
    public static String string_upload_error = "An error occurred while uploading this file.";
    public static String string_upload_exists = "This language already exists. Please delete it before uploading the language again.";
    public static String string_upload_nofile = "The selected file does not exist.";
    private static final String LOCALIZATION_INDEX = "localization.xml";
    private static final String EXTERNAL_FILE_EXT = ".lang";
    private static final String INTERNAL_FILE_NAME = "Messages";
    private static final String INTERNAL_FILE_EXT = ".properties.zip";
    private static final String TAG_LANGUAGE = "language";
    private static final String ATT_LANG = "lang";
    public static final int RESULT_OK = 0;
    public static final int RESULT_ERROR = 1;
    public static final int RESULT_INVALID = 2;
    public static final int RESULT_ALREADY_EXISTS = 3;
    private DefaultListModel dlm = new DefaultListModel();
    private JList langList;
    private AbstractAction actDownload;
    private AbstractAction actDelete;
    private JComboBox inputLanguages;
    private AbstractAction actUpload;
    private AbstractAction actOk;
    private SftpContainer sftp;
    private String intDir;
    private String packDir;
    private String webDir;
    private Locale[] uploadedLocales;
    private Locale[] installedLocales;
    private Preferences prefs = Preferences.userNodeForPackage(this.getClass());

    public static void adoptLocalization(Messages messages) {
        string_title = messages.getString("local.dialog.title");
        string_lang_available = messages.getString("local.dialog.lang.available");
        string_lang_upload = messages.getString("local.dialog.lang.upload");
        string_btn_download = messages.getString("local.dialog.btn.download");
        string_btn_delete = messages.getString("local.dialog.btn.delete");
        string_btn_upload = messages.getString("local.dialog.btn.upload");
        string_btn_do_upload = messages.getString("local.dialog.btn.do_upload");
        string_btn_unlock = messages.getString("local.dialog.btn.unlock");
        string_btn_ok = messages.getString("local.dialog.btn.ok");
        string_deletion_success = messages.getString("local.dialog.deletion.success");
        string_deletion_invalid = messages.getString("local.dialog.deletion.invalid");
        string_deletion_error = messages.getString("local.dialog.deletion.error");
        string_files = messages.getString("local.dialog.files");
        string_upload_success = messages.getString("local.dialog.upload.success");
        string_upload_invalid = messages.getString("local.dialog.upload.invalid");
        string_upload_error = messages.getString("local.dialog.upload.error");
        string_upload_exists = messages.getString("local.dialog.upload.exists");
        string_upload_nofile = messages.getString("local.dialog.upload.nofile");
    }

    public LocalizationUpload(Frame frame, SftpContainer sftpContainer, String string, String string2, String string3, Locale[] localeArray) {
        super(frame, string_title, true);
        Serializable serializable;
        this.setResizable(false);
        this.sftp = sftpContainer;
        this.intDir = string2;
        this.webDir = string;
        this.packDir = string3;
        this.installedLocales = localeArray;
        sftpContainer.addSftpContainerListener(new SftpContainerListener(){

            @Override
            public void sftpConnectionReady() {
                LocalizationUpload.this.actUpload.setEnabled(true);
                LocalizationUpload.this.actDelete.setEnabled(true);
                LocalizationUpload.this.inputLanguages.setEnabled(true);
            }

            @Override
            public void sftpConnectionUnready() {
                LocalizationUpload.this.actUpload.setEnabled(false);
                LocalizationUpload.this.actDelete.setEnabled(false);
                LocalizationUpload.this.inputLanguages.setEnabled(false);
            }
        });
        this.actDownload = new AbstractAction(string_btn_download){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object e = LocalizationUpload.this.langList.getSelectedValue();
                if (LocalizationUpload.this.langList.getSelectedValue() instanceof LanguageObject) {
                    LocalizationUpload.this.download((LanguageObject)e);
                }
            }
        };
        this.actDelete = new AbstractAction(string_btn_delete){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object e = LocalizationUpload.this.langList.getSelectedValue();
                if (LocalizationUpload.this.langList.getSelectedValue() instanceof LanguageObject && !((LanguageObject)e).installed) {
                    int n = LocalizationUpload.this.delete((LanguageObject)e);
                    switch (n) {
                        case 0: {
                            JOptionPane.showMessageDialog(LocalizationUpload.this, string_deletion_success);
                            break;
                        }
                        case 2: {
                            JOptionPane.showMessageDialog(LocalizationUpload.this, string_deletion_invalid);
                            break;
                        }
                        case 1: {
                            JOptionPane.showMessageDialog(LocalizationUpload.this, string_deletion_error);
                        }
                    }
                }
            }
        };
        this.actUpload = new AbstractAction(string_btn_upload){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(LocalizationUpload.this.prefs.get("defaultDir", null));
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().endsWith(LocalizationUpload.EXTERNAL_FILE_EXT);
                    }

                    @Override
                    public String getDescription() {
                        return string_files;
                    }
                });
                if (jFileChooser.showDialog(LocalizationUpload.this, string_btn_upload) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    LocalizationUpload.this.prefs.put("defaultDir", file.getAbsolutePath());
                    if (file.exists()) {
                        int n = LocalizationUpload.this.upload((LanguageObject)LocalizationUpload.this.inputLanguages.getSelectedItem(), file);
                        switch (n) {
                            case 0: {
                                JOptionPane.showMessageDialog(LocalizationUpload.this, string_upload_success);
                                break;
                            }
                            case 1: {
                                JOptionPane.showMessageDialog(LocalizationUpload.this, string_upload_error);
                                break;
                            }
                            case 2: {
                                JOptionPane.showMessageDialog(LocalizationUpload.this, string_upload_invalid);
                                break;
                            }
                            case 3: {
                                JOptionPane.showMessageDialog(LocalizationUpload.this, string_upload_exists);
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(LocalizationUpload.this, string_upload_nofile);
                    }
                }
            }
        };
        this.inputLanguages = new JComboBox();
        ArrayList<LanguageObject> arrayList = new ArrayList<LanguageObject>();
        for (String object2 : Locale.getISOLanguages()) {
            serializable = new Locale(object2);
            arrayList.add(new LanguageObject((Locale)serializable, false));
        }
        Collections.sort(arrayList);
        for (LanguageObject languageObject : arrayList) {
            this.inputLanguages.addItem(languageObject);
            if (!languageObject.loc.getLanguage().equals(Locale.getDefault().getLanguage())) continue;
            this.inputLanguages.setSelectedItem(languageObject);
        }
        this.langList = new JList(this.dlm);
        this.langList.setSelectionMode(0);
        this.langList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LocalizationUpload.this.actDownload.setEnabled(LocalizationUpload.this.langList.getSelectedIndex() != -1);
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Object e = LocalizationUpload.this.langList.getSelectedValue();
                    if (LocalizationUpload.this.langList.getSelectedValue() instanceof LanguageObject) {
                        LocalizationUpload.this.actDelete.setEnabled(!((LanguageObject)e).installed && LocalizationUpload.this.sftp.isReady());
                    }
                }
            }
        });
        if (!sftpContainer.isReady()) {
            this.actDelete.setEnabled(false);
            this.actDownload.setEnabled(false);
            this.actUpload.setEnabled(false);
            this.inputLanguages.setEnabled(false);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string_lang_available));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JScrollPane(this.langList, 22, 30), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JButton(this.actDownload), gridBagConstraints);
        jPanel.add((Component)new JButton(this.actDelete), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(string_lang_upload));
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)this.inputLanguages, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)new JButton(this.actUpload), gridBagConstraints);
        JSshUnlockButton jSshUnlockButton = new JSshUnlockButton(string_btn_unlock);
        jSshUnlockButton.setSftpContainer(sftpContainer);
        this.actOk = new AbstractAction(string_btn_ok){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocalizationUpload.this.setVisible(false);
            }
        };
        serializable = new JButtonBar();
        ((JButtonBar)serializable).setLeftButtons(jSshUnlockButton);
        ((JButtonBar)serializable).setRightButtons(this.actOk);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel3, "Center");
        this.getContentPane().add((Component)serializable, "South");
        this.pack();
        this.readUploadedLanguages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int upload(LanguageObject languageObject, File file) {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = this.getUploadedDocument();
        if (document == null) {
            return 1;
        }
        boolean bl = false;
        for (Object object : document.getRootElement().getChildren(TAG_LANGUAGE)) {
            if (!((Element)object).getAttributeValue(ATT_LANG).equals(languageObject.loc.getLanguage())) continue;
            bl = true;
        }
        if (bl) {
            return 3;
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        try {
            Object object;
            zipOutputStream.putNextEntry(new ZipEntry("Messages_" + languageObject.loc.getLanguage() + ".properties"));
            inputStream = new FileInputStream(file);
            object = new byte[1024];
            int n = 0;
            while (-1 != (n = inputStream.read((byte[])object))) {
                zipOutputStream.write((byte[])object, 0, n);
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            String string = "Messages_" + languageObject.loc.getLanguage() + INTERNAL_FILE_EXT;
            this.sftp.getFileInterface().writeToFile(this.intDir + "/" + string, byteArrayOutputStream.toByteArray());
            Element element = new Element(TAG_LANGUAGE);
            element.setText(string);
            element.setAttribute(ATT_LANG, languageObject.loc.getLanguage());
            document.getRootElement().addContent(element);
            this.saveUploadedDocument(document);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        this.readUploadedLanguages();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int download(LanguageObject languageObject) {
        JFileChooser jFileChooser = new JFileChooser(this.prefs.get("defaultDir", null));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(LocalizationUpload.EXTERNAL_FILE_EXT);
            }

            @Override
            public String getDescription() {
                return "Translation Files";
            }
        });
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.prefs.put("defaultDir", file.getAbsolutePath());
            if (!file.getName().endsWith(EXTERNAL_FILE_EXT)) {
                file = new File(file.getAbsolutePath() + EXTERNAL_FILE_EXT);
            }
            URL uRL = this.getUrl(languageObject);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                if (languageObject.installed) {
                    inputStream = uRL.openStream();
                } else {
                    inputStream = new ZipInputStream(uRL.openStream());
                    ((ZipInputStream)inputStream).getNextEntry();
                }
                outputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                int n = 0;
                while (-1 != (n = inputStream.read(byArray))) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                int n = 1;
                return n;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return 0;
    }

    private int delete(LanguageObject languageObject) {
        if (languageObject.installed) {
            return 2;
        }
        Document document = this.getUploadedDocument();
        if (document == null) {
            return 1;
        }
        Element element = null;
        for (Element element2 : document.getRootElement().getChildren(TAG_LANGUAGE)) {
            if (!element2.getAttributeValue(ATT_LANG).equals(languageObject.loc.getLanguage())) continue;
            element = element2;
        }
        if (element == null) {
            return 2;
        }
        try {
            this.sftp.getFileInterface().remove(this.intDir + "/" + element.getText());
        }
        catch (NoRouteToHostException noRouteToHostException) {
            noRouteToHostException.printStackTrace();
            return 1;
        }
        element.detach();
        try {
            this.saveUploadedDocument(document);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 1;
        }
        this.readUploadedLanguages();
        return 0;
    }

    private URL getUrl(LanguageObject languageObject) {
        URL uRL = null;
        uRL = languageObject.installed ? this.getInstalledUrl(languageObject) : this.getUploadedUrl(languageObject);
        return uRL;
    }

    private URL getInstalledUrl(LanguageObject languageObject) {
        URL uRL = null;
        String string = languageObject.loc.getLanguage();
        uRL = string == "en" ? this.getClass().getClassLoader().getResource(this.packDir + "/Messages.properties") : this.getClass().getClassLoader().getResource(this.packDir + "/Messages_" + string + ".properties");
        return uRL;
    }

    private URL getUploadedUrl(LanguageObject languageObject) {
        URL uRL = null;
        try {
            uRL = new URL(this.webDir + "/Messages_" + languageObject.loc.getLanguage() + INTERNAL_FILE_EXT);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    private void refreshList() {
        this.dlm.removeAllElements();
        if (this.installedLocales != null) {
            for (Locale locale : this.installedLocales) {
                this.dlm.addElement(new LanguageObject(locale, true));
            }
        }
        if (this.uploadedLocales != null) {
            for (Locale locale : this.uploadedLocales) {
                this.dlm.addElement(new LanguageObject(locale, false));
            }
        }
    }

    private void saveUploadedDocument(Document document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new XMLOutputter(Format.getPrettyFormat()).output(document, (OutputStream)byteArrayOutputStream);
        this.sftp.getFileInterface().writeToFile(this.intDir + "/" + LOCALIZATION_INDEX, byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getUploadedDocument() {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(this.webDir + "/" + LOCALIZATION_INDEX);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            Document document = new SAXBuilder().build(inputStream);
            return document;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (JDOMException jDOMException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            Document document = new Document(new Element("localizations"));
            return document;
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private void readUploadedLanguages() {
        try {
            System.out.println("---------------------" + this.webDir);
            System.out.println(new URL(this.webDir + "/" + LOCALIZATION_INDEX));
            Document document = this.getUploadedDocument();
            if (document != null) {
                this.uploadedLocales = LocalizationTools.getLocalizations(document);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.refreshList();
    }

    public static void openUploadDialog(Frame frame, SftpContainer sftpContainer, String string, String string2, String string3, Locale[] localeArray) {
        LocalizationUpload localizationUpload = new LocalizationUpload(frame, sftpContainer, string, string2, string3, localeArray);
        localizationUpload.setLocationRelativeTo(frame);
        localizationUpload.setVisible(true);
    }

    class LanguageObject
    implements Comparable<LanguageObject> {
        private Locale loc;
        private boolean installed = false;

        public LanguageObject(String string, boolean bl) {
            this(new Locale(string), bl);
        }

        public LanguageObject(Locale locale, boolean bl) {
            this.loc = locale;
            this.installed = bl;
        }

        public String toString() {
            if (this.installed) {
                return "* " + this.loc.getDisplayLanguage() + " (" + this.loc.getLanguage() + ")";
            }
            return this.loc.getDisplayLanguage() + " (" + this.loc.getLanguage() + ")";
        }

        @Override
        public int compareTo(LanguageObject languageObject) {
            return this.toString().compareTo(languageObject.toString());
        }
    }
}

