/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.monitor;

import de.babtec.globals.bmx.BMXTelegram;
import de.babtec.globals.esf.ESFData;
import de.babtec.globals.esf.ESFElement;
import de.babtec.globals.knx.address.EIBAddress2;
import de.babtec.globals.knx.datatype.DataType;
import de.eibport.components.monitor.BmxMonitorController;
import de.eibport.components.monitor.BmxMonitorTools;
import de.eibport.components.monitor.BmxTableColumn;
import de.eibport.components.monitor.MonitorModelListener;
import de.eibport.net.bmx.BMXConnectionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class BmxMonitorPanel
extends JPanel
implements MonitorModelListener<BMXTelegram> {
    public final BmxTableColumn COLUMN_TIME = new BmxTableColumn(0, "Date"){
        SimpleDateFormat sdf;
        {
            this.sdf = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
        }

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return this.sdf.format(new Date(bMXTelegram.getTimestamp()));
        }
    };
    public final BmxTableColumn COLUMN_PHYSADDR = new BmxTableColumn(1, "Phys. Address"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            if (bMXTelegram.isEnhanced()) {
                return bMXTelegram.getPhysAdrRepresentation(true);
            }
            return "";
        }
    };
    public final BmxTableColumn COLUMN_ADDR = new BmxTableColumn(11, "Group Address"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return EIBAddress2.getStrAddress(bMXTelegram.getAddress());
        }
    };
    public final BmxTableColumn COLUMN_VALUE = new BmxTableColumn(20, "Value"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            ESFElement eSFElement = BmxMonitorPanel.this.esf.getElementByAddress(bMXTelegram.getAddress());
            if (eSFElement != null && eSFElement.getDataType().getTypeIndex() != 0) {
                DataType<?> dataType = eSFElement.getDataType();
                return dataType.getValueAsString(dataType.getValue(bMXTelegram.getValue()));
            }
            if (bMXTelegram.getSize() == 15) {
                return BmxMonitorTools.getAsString(bMXTelegram.getValue());
            }
            return "";
        }
    };
    public final BmxTableColumn COLUMN_DATATYPE = new BmxTableColumn(21, "Datatype"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            ESFElement eSFElement = BmxMonitorPanel.this.esf.getElementByAddress(bMXTelegram.getAddress());
            if (eSFElement != null && eSFElement.getDataType().getTypeIndex() != 0) {
                DataType<?> dataType = eSFElement.getDataType();
                return dataType.toString();
            }
            return "";
        }
    };
    public final BmxTableColumn COLUMN_DATA = new BmxTableColumn(22, "Data"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return BmxMonitorTools.getAsHex(bMXTelegram.getValue(), BmxMonitorTools.dataVisible[bMXTelegram.getSize()]);
        }
    };
    public final BmxTableColumn COLUMN_DATAWIDTH = new BmxTableColumn(23, "DataWidth"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return BmxMonitorTools.data[bMXTelegram.getSize()];
        }
    };
    public final BmxTableColumn COLUMN_MAINGROUP = new BmxTableColumn(30, "Maingroup"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return BmxMonitorPanel.this.esf.getMainName(BmxMonitorPanel.this.esf.getElementByAddress(bMXTelegram.getAddress()));
        }
    };
    public final BmxTableColumn COLUMN_MIDDLEGROUP = new BmxTableColumn(31, "Middlegroup"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return BmxMonitorPanel.this.esf.getMiddleName(BmxMonitorPanel.this.esf.getElementByAddress(bMXTelegram.getAddress()));
        }
    };
    public final BmxTableColumn COLUMN_SUBGROUP = new BmxTableColumn(32, "Subgroup"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return BmxMonitorPanel.this.esf.getSubName(bMXTelegram.getAddress());
        }
    };
    public final BmxTableColumn COLUMN_FUNCTION = new BmxTableColumn(40, "Function"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return bMXTelegram.getCompleteTypeString();
        }
    };
    public final BmxTableColumn COLUMN_SRCTYPE = new BmxTableColumn(40, "Src Type"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            if (bMXTelegram.isEnhanced()) {
                return bMXTelegram.getSrcTypeRepresentation(true);
            }
            return "";
        }
    };
    public final BmxTableColumn COLUMN_BUSREPEAT = new BmxTableColumn(50, "Bus Repeatition"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            if (bMXTelegram.isEnhanced()) {
                return bMXTelegram.isRepeatition() ? "yes" : "no";
            }
            return "";
        }
    };
    public final BmxTableColumn COLUMN_BUSPRIORITY = new BmxTableColumn(51, "Bus Priority"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            if (bMXTelegram.isEnhanced()) {
                return bMXTelegram.getPriorityRepresentation(false);
            }
            return "";
        }
    };
    public final BmxTableColumn COLUMN_RTCNT = new BmxTableColumn(52, "Routing Counter"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            if (bMXTelegram.isEnhanced()) {
                return Integer.toString(bMXTelegram.getRcnt());
            }
            return "";
        }
    };
    public final BmxTableColumn COLUMN_SYSTEMID = new BmxTableColumn(10, "System ID"){

        @Override
        public String getValue(BMXTelegram bMXTelegram) {
            return Integer.toString(bMXTelegram.getId());
        }
    };
    private ESFData esf;
    private Vector<BmxTableColumn> columns = new Vector();
    private BmxMonitorController controller;
    private JComboBox inputAction;
    private JTable table;
    private DefaultTableModel dtm;
    private JPanel top;
    private JPanel statusbar;
    private JLabel statusLabelCount = new JLabel();
    private JPanel options;

    public BmxMonitorPanel(BMXConnectionHandler bMXConnectionHandler, ESFData eSFData) {
        this.esf = eSFData;
        this.controller = new BmxMonitorController(bMXConnectionHandler){

            @Override
            protected void actionFinished(int n) {
                BmxMonitorPanel.this.dtm.fireTableDataChanged();
            }

            @Override
            protected void actionStarted(int n) {
            }

            @Override
            protected void actionCanceled(int n) {
                BmxMonitorPanel.this.dtm.fireTableDataChanged();
            }
        };
        this.controller.getModel().addMonitorModelListener(this);
        this.top = new JPanel();
        this.inputAction = new JComboBox<String>(new String[]{"State Table", "History"});
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BmxMonitorPanel.this.inputAction.getSelectedIndex() == 0) {
                    BmxMonitorPanel.this.controller.refreshStatusTable();
                } else {
                    BmxMonitorPanel.this.controller.refreshHistory();
                }
            }
        });
        JButton jButton2 = new JButton("CSV Export");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.export();
            }
        });
        this.top.add(this.inputAction);
        this.top.add(jButton);
        this.top.add(jButton2);
        this.statusbar = new JPanel();
        this.statusbar.add(this.statusLabelCount);
        this.createTable();
        this.createOptionsPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.top, "North");
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.table), this.options);
        jSplitPane.setDividerLocation(0.9);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setOneTouchExpandable(true);
        this.add((Component)jSplitPane, "Center");
        this.add((Component)this.statusbar, "South");
    }

    private void export() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ".csv";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".csv");
            }
        });
        String string = "\t";
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            try {
                int n2;
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().endsWith(".csv")) {
                    file = new File(file.getName() + ".csv");
                }
                PrintStream printStream = new PrintStream(file);
                int n3 = this.dtm.getColumnCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    printStream.print(this.dtm.getColumnName(n2));
                    if (n2 >= n3 - 1) continue;
                    printStream.print(string);
                }
                printStream.println();
                for (n2 = 0; n2 < this.dtm.getRowCount(); ++n2) {
                    for (int i = 0; i < n3; ++i) {
                        printStream.print(this.dtm.getValueAt(n2, i));
                        if (i >= n3 - 1) continue;
                        printStream.print(string);
                    }
                    printStream.println();
                }
                printStream.close();
                JOptionPane.showMessageDialog(this, "Finished Export....");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void createTable() {
        this.dtm = new DefaultTableModel(){

            public void setColumnIdentifiers(Vector vector) {
                Collections.sort(vector);
                super.setColumnIdentifiers(vector);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public String getColumnName(int n) {
                BmxTableColumn bmxTableColumn = (BmxTableColumn)this.columnIdentifiers.get(n);
                return bmxTableColumn.getHeaderValue().toString();
            }

            @Override
            public int getRowCount() {
                return BmxMonitorPanel.this.controller.getModel().getItemCount();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                BmxTableColumn bmxTableColumn = (BmxTableColumn)this.columnIdentifiers.get(n2);
                return bmxTableColumn.getValue(BmxMonitorPanel.this.controller.getModel().getItem(n));
            }
        };
        this.table = new JTable(this.dtm);
        this.columns.add(this.COLUMN_TIME);
        this.columns.add(this.COLUMN_ADDR);
        this.columns.add(this.COLUMN_VALUE);
        this.columns.add(this.COLUMN_DATATYPE);
        this.columns.add(this.COLUMN_DATA);
        this.columns.add(this.COLUMN_DATAWIDTH);
        this.columns.add(this.COLUMN_MAINGROUP);
        this.columns.add(this.COLUMN_MIDDLEGROUP);
        this.columns.add(this.COLUMN_SUBGROUP);
        this.columns.add(this.COLUMN_FUNCTION);
        this.dtm.setColumnIdentifiers(this.columns);
    }

    private void createOptionsPanel() {
        this.options = new JPanel();
        this.options.setLayout(new BoxLayout(this.options, 1));
        JCheckBox jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_TIME.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_TIME, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_ADDR.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_ADDR, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_VALUE.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_VALUE, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_DATATYPE.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_DATATYPE, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_DATA.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_DATA, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_DATAWIDTH.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_DATAWIDTH, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_MAINGROUP.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_MAINGROUP, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_MIDDLEGROUP.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_MIDDLEGROUP, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_SUBGROUP.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_SUBGROUP, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
        jCheckBox = new JCheckBox(new AbstractAction(this.COLUMN_FUNCTION.toString()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BmxMonitorPanel.this.setColumnVisibility(BmxMonitorPanel.this.COLUMN_FUNCTION, ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jCheckBox.setSelected(true);
        this.options.add(jCheckBox);
    }

    private void setColumnVisibility(BmxTableColumn bmxTableColumn, boolean bl) {
        if (bl) {
            if (!this.columns.contains(bmxTableColumn)) {
                this.columns.add(bmxTableColumn);
            }
        } else {
            this.columns.remove(bmxTableColumn);
        }
        this.dtm.setColumnIdentifiers(this.columns);
    }

    @Override
    public void itemAdded(BMXTelegram bMXTelegram) {
        this.statusLabelCount.setText("Items: " + this.controller.getModel().getItemCount());
    }

    @Override
    public void itemRemoved(BMXTelegram bMXTelegram) {
        this.statusLabelCount.setText("Items: " + this.controller.getModel().getItemCount());
    }

    public void itemsAdded(BMXTelegram[] bMXTelegramArray) {
        this.statusLabelCount.setText("Items: " + this.controller.getModel().getItemCount());
    }

    @Override
    public void modelCleared() {
        this.dtm.fireTableDataChanged();
        this.statusLabelCount.setText("Items: " + this.controller.getModel().getItemCount());
    }
}

