/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.ssh;

import de.eibport.components.WindowUtils;
import de.eibport.net.sftp.EibPortSftpException;
import de.eibport.net.sftp.SftpContainer;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class SftpUnlockDialog
extends JDialog {
    public static final int UNLOCK_RUNNING = -1;
    public static final int UNLOCK_SUCCESS = 0;
    public static final int UNLOCK_FAILED = 1;
    public static final int UNLOCK_CANCELLED = 2;
    private SftpContainer sftpContainer;
    private static String STRING_DIALOG_TITLE = "Login eibPort";
    private static String STRING_PASSPHRASE = "eibPort String";
    private static String STRING_PASSPHRASE_ERROR = "<html><font color=red>Invalid eibPort String</font></html>";
    private static String STRING_BUTTON_OK = "OK";
    private static String STRING_BUTTON_CANCEL = "Cancel";
    private String message = null;
    private JPasswordField inputPassphrase;
    private JLabel labelInfo;
    private JButton btnOK;
    private JButton btnCancel;
    private Thread unlockThread;
    private Thread unlockWaitThread;
    private int unlockStatus = -1;

    public static void adoptLocalization(Messages messages) {
        STRING_DIALOG_TITLE = messages.getString("sftpunlock.dialog.title");
        STRING_PASSPHRASE = messages.getString("sftpunlock.dialog.passphrase");
        STRING_PASSPHRASE_ERROR = messages.getString("sftpunlock.dialog.error");
        STRING_BUTTON_OK = messages.getString("sftpunlock.dialog.ok");
        STRING_BUTTON_CANCEL = messages.getString("sftpunlock.dialog.cancel");
    }

    private SftpUnlockDialog(Dialog dialog, SftpContainer sftpContainer) {
        super(dialog, "Secure Connection", true);
        this.sftpContainer = sftpContainer;
        this.prepareDialog();
    }

    private SftpUnlockDialog(Frame frame, SftpContainer sftpContainer) {
        super(frame, true);
        this.sftpContainer = sftpContainer;
        this.prepareDialog();
    }

    private void prepareDialog() {
        this.setTitle(STRING_DIALOG_TITLE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (SftpUnlockDialog.this.unlockStatus == -1 || SftpUnlockDialog.this.unlockStatus == 1) {
                    SftpUnlockDialog.this.unlockStatus = 2;
                }
                if (SftpUnlockDialog.this.unlockThread != null) {
                    SftpUnlockDialog.this.unlockThread.interrupt();
                    SftpUnlockDialog.this.unlockThread = null;
                }
                if (SftpUnlockDialog.this.unlockWaitThread != null) {
                    SftpUnlockDialog.this.unlockWaitThread.interrupt();
                    SftpUnlockDialog.this.unlockWaitThread = null;
                }
            }
        });
        this.createContents();
    }

    private void createContents() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 0));
        container.add((Component)jPanel, "Center");
        this.labelInfo = new JLabel(STRING_PASSPHRASE);
        jPanel.add(this.labelInfo);
        this.inputPassphrase = new JPasswordField();
        this.inputPassphrase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (keyEvent.getKeyCode() == 10) {
                    SftpUnlockDialog.this.btnOK.doClick();
                } else if (keyEvent.getKeyCode() == 27) {
                    SftpUnlockDialog.this.btnCancel.doClick();
                }
            }
        });
        jPanel.add(this.inputPassphrase);
        this.inputPassphrase.setPreferredSize(new Dimension(250, this.inputPassphrase.getPreferredSize().height));
        JPanel jPanel2 = new JPanel();
        container.add((Component)jPanel2, "South");
        this.btnOK = new JButton(STRING_BUTTON_OK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SftpUnlockDialog.this.tryUnlock(SftpUnlockDialog.this.inputPassphrase.getPassword());
            }
        });
        jPanel2.add(this.btnOK);
        this.btnCancel = new JButton(STRING_BUTTON_CANCEL);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SftpUnlockDialog.this.unlockStatus = 2;
                SftpUnlockDialog.this.dispatchEvent(new WindowEvent(SftpUnlockDialog.this, 201));
            }
        });
        jPanel2.add(this.btnCancel);
        this.pack();
        this.inputPassphrase.requestFocus();
        WindowUtils.centerComponent(this, this.getOwner());
    }

    private void tryUnlock(final char[] cArray) {
        if (cArray != null) {
            this.inputPassphrase.setEnabled(false);
            this.btnOK.setEnabled(false);
            this.unlockThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SftpUnlockDialog.this.sftpContainer.init(new String(cArray));
                        SftpUnlockDialog.this.unlockStatus = 0;
                    }
                    catch (EibPortSftpException eibPortSftpException) {
                        JOptionPane.showMessageDialog(SftpUnlockDialog.this, eibPortSftpException.getLocalizedMessage());
                        SftpUnlockDialog.this.unlockStatus = 1;
                    }
                    SftpUnlockDialog.this.unlockThread = null;
                }
            };
            this.unlockWaitThread = new Thread(){

                @Override
                public void run() {
                    while (SftpUnlockDialog.this.unlockStatus == -1) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (SftpUnlockDialog.this.unlockStatus == 0 || SftpUnlockDialog.this.unlockStatus == 2) {
                        SftpUnlockDialog.this.setVisible(false);
                    } else {
                        SftpUnlockDialog.this.labelInfo.setText(STRING_PASSPHRASE_ERROR);
                        SftpUnlockDialog.this.btnOK.setEnabled(true);
                        SftpUnlockDialog.this.inputPassphrase.setEnabled(true);
                    }
                    SftpUnlockDialog.this.unlockWaitThread = null;
                }
            };
            this.unlockStatus = -1;
            this.unlockThread.start();
            this.unlockWaitThread.start();
        }
    }

    public static int open(Component component, SftpContainer sftpContainer) {
        SftpUnlockDialog sftpUnlockDialog = new SftpUnlockDialog(JOptionPane.getFrameForComponent(component), sftpContainer);
        sftpUnlockDialog.setLocationRelativeTo(component);
        sftpUnlockDialog.setVisible(true);
        return sftpUnlockDialog.unlockStatus;
    }

    public static int open(Dialog dialog, SftpContainer sftpContainer) {
        SftpUnlockDialog sftpUnlockDialog = new SftpUnlockDialog(dialog, sftpContainer);
        sftpUnlockDialog.setLocationRelativeTo(dialog);
        sftpUnlockDialog.setVisible(true);
        return sftpUnlockDialog.unlockStatus;
    }
}

