/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BasicHostInformation {
    protected InetAddress address;
    protected int http_port = 80;
    protected int jetty_http_port = 8080;
    protected int ssh_port = 36;
    protected int bmx_tcp_port = 1735;
    protected int bmx_udp_port = 1735;
    protected int system_id = 0;
    protected String epName;
    protected String fwVersion;
    protected String sernr;
    protected int sernrInt = -1;
    protected boolean enoceanAvailable = false;
    protected String enoceanBaseId;
    protected String enoceanVersion;
    protected String enoceanApiVersion;

    protected boolean parseYabusrc(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = "^(\\w+)\\s*=\\s*\"?(\\d+)\"?";
        Pattern pattern = Pattern.compile(string2, 64);
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches() || matcher.groupCount() < 2) continue;
            if (matcher.group(1).equals("bmx_tcp_port")) {
                this.bmx_tcp_port = Integer.parseInt(matcher.group(2));
                System.out.println("found bmx_tcp_port: " + this.bmx_tcp_port);
                continue;
            }
            if (matcher.group(1).equals("bmx_udp_port")) {
                this.bmx_udp_port = Integer.parseInt(matcher.group(2));
                System.out.println("found bmx_udp_port: " + this.bmx_udp_port);
                continue;
            }
            if (matcher.group(1).equals("ssh_port")) {
                this.ssh_port = Integer.parseInt(matcher.group(2));
                System.out.println("found ssh_port: " + this.ssh_port);
                continue;
            }
            if (matcher.group(1).equals("jetty_http_port")) {
                this.jetty_http_port = Integer.parseInt(matcher.group(2));
                System.out.println("found ws_port: " + this.jetty_http_port);
                continue;
            }
            if (matcher.group(1).equals("http_port")) {
                this.http_port = Integer.parseInt(matcher.group(2));
                System.out.println("found http_port: " + this.http_port);
                continue;
            }
            if (!matcher.group(1).equals("system_id")) continue;
            this.system_id = Integer.parseInt(matcher.group(2));
        }
        return true;
    }

    protected void parseEnoceanStatus(String string) {
        if (string == null) {
            System.out.println("enocean status file is empty");
            return;
        }
        System.out.println("parsing enocean_status: " + string);
        String string2 = ".*h/w found, base id 0x([0-9a-f]*), version ([\\d\\.]*), api version ([\\d\\.]*)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.enoceanAvailable = true;
            this.enoceanBaseId = matcher.group(1);
            this.enoceanVersion = matcher.group(2);
            this.enoceanApiVersion = matcher.group(3);
        } else {
            this.enoceanAvailable = false;
        }
    }

    public boolean getEnOceanSernr() {
        return this.sernr.startsWith("BT03") || this.sernr.startsWith("BT07");
    }

    public boolean getEnOceanAvailable() {
        return this.enoceanAvailable;
    }

    public String getEnOceanBaseId() {
        return this.enoceanBaseId;
    }

    public String getEnOceanVersion() {
        return this.enoceanVersion;
    }

    public String getEnOceanApiVersion() {
        return this.enoceanApiVersion;
    }

    public String getEpName() {
        return this.epName;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public String getSernr() {
        return this.sernr;
    }

    public int getSernrAsInt() {
        if (this.sernrInt == -1) {
            try {
                this.sernrInt = Integer.parseInt(this.sernr.substring(2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.sernrInt;
    }

    public InetAddress getHost() {
        return this.address;
    }

    public int getHttpPort() {
        return this.http_port;
    }

    public void setHttpPort(int n) {
        this.http_port = n;
    }

    public int getJettyHttpPort() {
        return this.jetty_http_port;
    }

    public int getSshPort() {
        return this.ssh_port;
    }

    public void setSshPort(int n) {
        this.ssh_port = n;
    }

    public int getBmxTcpPort() {
        return this.bmx_tcp_port;
    }

    public void setBmxTcpPort(int n) {
        this.bmx_tcp_port = n;
    }

    public int getBmxUdpPort() {
        return this.bmx_udp_port;
    }

    public void setBmxUdpPort(int n) {
        this.bmx_udp_port = n;
    }
}

