/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net;

import de.eibport.net.BasicHostInformation;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostInformation
extends BasicHostInformation {
    public static final String PATH_SERVLET_SECURITYMANAGER = "/webif/SecurityModule";
    public static final String PATH_SERVLET_UPNP_CONFIG = "/web.upnp/config.jsp";

    public HostInformation(String string, int n) throws IOException {
        this.loadPorts(string, n);
    }

    private boolean loadPorts(String string, int n) throws IOException {
        BufferedReader bufferedReader;
        URL uRL;
        try {
            this.address = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        this.http_port = n == -1 ? 80 : n;
        try {
            uRL = new URL("http", string, n, "/yabusrc");
            this.parseYabusrc(uRL.openConnection().getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            try {
                URL uRL2 = new URL("http", string, n, "/bxdrc");
                System.out.println("reading " + uRL2);
                return this.parseYabusrc(uRL2.openConnection().getInputStream());
            }
            catch (FileNotFoundException fileNotFoundException2) {
                fileNotFoundException2.printStackTrace();
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        try {
            uRL = new URL("http", string, n, "/tmp/sernr");
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.sernr = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            uRL = new URL("http", string, n, "/fw_version");
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.fwVersion = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            uRL = new URL("http", string, n, "/name");
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.epName = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            uRL = new URL("http", string, n, "/enocean_status");
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.parseEnoceanStatus(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public URL getBaseURL() {
        URL uRL = null;
        try {
            uRL = new URL("http", this.address.getHostAddress(), this.http_port, "/");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public URL getURL(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        URL uRL = null;
        try {
            uRL = new URL("http", this.address.getHostAddress(), this.http_port, string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public static int getComparableVersion(String string) {
        Pattern pattern = Pattern.compile(".*?(\\d*)\\.(\\d*).(\\d*)(?:-pre(\\d*))?");
        Matcher matcher = pattern.matcher(string);
        int n = 255;
        if (matcher.matches()) {
            n |= Integer.parseInt(matcher.group(1)) << 24;
            n |= Integer.parseInt(matcher.group(2)) << 16;
            n |= Integer.parseInt(matcher.group(3)) << 8;
            if (matcher.groupCount() > 4) {
                n |= Integer.parseInt(matcher.group(4));
            }
        }
        return n;
    }
}

