/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx;

import de.babtec.globals.bmx.BMXPackets;
import de.babtec.globals.bmx.BMXTelegram;
import de.babtec.globals.jobdata.BMXBasicJobData;
import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.LibID;
import de.babtec.globals.utils.ByteConv;
import de.babtec.globals.utils.ParserInterface;
import de.eibport.net.bmx.BMXAddressTable;
import de.eibport.net.bmx.BMXConnectionThread;
import de.eibport.net.bmx.BMXException;
import de.eibport.net.bmx.interfaces.IBMXConnection;
import de.eibport.net.bmx.interfaces.IBMXListener;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.swing.event.EventListenerList;

public class BMXConnection
implements IBMXConnection {
    public static final int PING_DELAY = 15000;
    public static final int SOCKET_TIMEOUT = 30000;
    public static final int RECONNECT_TIME = 10000;
    protected String hostname;
    protected int port;
    protected String clientname;
    protected int loginType;
    protected String loginId;
    protected boolean online = false;
    protected boolean enocean_online = false;
    protected BMXConnectionThread con;
    protected BMXAddressTable addressTable;
    protected ParserInterface enOceanParser;
    private String serverName;
    private String serverVersion;
    private String protocol;
    private double protocolVersion;
    protected EventListenerList bmxListeners = new EventListenerList();

    public BMXConnection(String string, int n, String string2, int n2, String string3) {
        this.hostname = string;
        this.port = n;
        this.clientname = string2;
        this.loginType = n2;
        this.loginId = string3;
    }

    public void setEnOceanParser(ParserInterface parserInterface) {
        this.enOceanParser = parserInterface;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isConnected() {
        if (this.con == null) {
            return false;
        }
        return this.con.isAlive();
    }

    public boolean getEnOceanStatus() {
        return this.enocean_online;
    }

    public void setEnOceanOnline(boolean bl) {
        if (this.enocean_online == bl) {
            return;
        }
        this.enocean_online = bl;
        if (bl) {
            this.sendPacket(BMXPackets.constructEnOcean(3, new byte[0]));
        } else {
            this.sendPacket(BMXPackets.constructEnOcean(4, new byte[0]));
        }
    }

    public void enableAdressTable() throws IllegalStateException {
        if (!this.isOnline()) {
            throw new IllegalStateException("Socket must be set online first! (BMXConnection.setOnline(true)");
        }
        this.addressTable = new BMXAddressTable(this);
        this.sendPacket(BMXPackets.constructGetTeleTabelle());
    }

    public boolean addressTableEnabled() {
        return this.addressTable != null;
    }

    public boolean addressTableIsCompleted() {
        return this.addressTable.isCompleted();
    }

    public void addBMXListener(IBMXListener iBMXListener) {
        this.bmxListeners.add(IBMXListener.class, iBMXListener);
    }

    public void removeBMXListener(IBMXListener iBMXListener) {
        this.bmxListeners.remove(IBMXListener.class, iBMXListener);
    }

    @Override
    public void parsePacket(byte[] byArray, int n) {
        int n2 = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        switch (n2) {
            case 0: {
                byte[] byArray2 = new byte[n - 9];
                System.arraycopy(byArray, 8, byArray2, 0, n - 9);
                switch (byArray[4]) {
                    case 0: {
                        this.serverName = new String(byArray2);
                        System.out.println("connected to '" + this.serverName + "'");
                        break;
                    }
                    case 1: {
                        this.serverVersion = new String(byArray2);
                        break;
                    }
                    case 2: {
                        this.protocol = new String(byArray2);
                        break;
                    }
                    case 3: {
                        this.protocolVersion = Double.parseDouble(new String(byArray2).trim());
                    }
                }
                break;
            }
            case 2: {
                System.out.println("Got disconnect. Authentication not yet enabled?");
                this.closeSocket();
                this.socketConnectionInterrupted();
                break;
            }
            case 4: {
                this.sendTelegramToListeners(new BMXTelegram(byArray));
                break;
            }
            case 6: {
                BMXTelegram bMXTelegram = new BMXTelegram(byArray, true);
                if (bMXTelegram.getAddress() == 0 && bMXTelegram.getDate() == 0.0) {
                    if (this.addressTable != null) {
                        this.addressTable.addressTableCompleted();
                    }
                    this.addressTableCompleted();
                } else if (this.addressTable != null) {
                    this.addressTable.insertTelegram(bMXTelegram);
                }
                this.sendTelegramToListeners(bMXTelegram);
                break;
            }
            case 43: {
                BMXTelegram bMXTelegram = new BMXTelegram(byArray, true);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.getTraceListe(bMXTelegram);
                }
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                System.err.println("Bus offline");
                break;
            }
            case 10: {
                System.err.println("got ping... sending pong");
                this.sendPacket(BMXPackets.constructPongPacket());
                break;
            }
            case 11: {
                System.err.println("got pong...");
                break;
            }
            case 30: {
                int n3 = ByteConv.byte2long(byArray, 4);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 8; i < 255 && byArray[i] != 0; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.getSystem(n3, stringBuffer.toString());
                }
                break;
            }
            case 127: {
                System.out.println("ANSWER TO GETPARAMETER");
                break;
            }
            case 100: {
                byte[] byArray3 = new byte[4];
                System.arraycopy(byArray, 4, byArray3, 0, 4);
                byte[] byArray4 = new byte[byArray.length - 9];
                System.arraycopy(byArray, 8, byArray4, 0, byArray.length - 9);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.getAutoPossibility(new LibID(byArray3), new String(byArray4));
                }
                break;
            }
            case 101: {
                byte[] byArray5 = new byte[4];
                System.arraycopy(byArray, 4, byArray5, 0, 4);
                byte[] byArray6 = new byte[byArray.length - 9];
                System.arraycopy(byArray, 8, byArray6, 0, byArray.length - 9);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    String string;
                    boolean bl = ByteConv.isUTF8(byArray6);
                    try {
                        string = new String(byArray6, bl ? "UTF-8" : "ISO-8859-15");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                        string = new String(byArray6);
                    }
                    iBMXListener.getAutoListe(new BMXBasicJobData(new LibID(byArray5), string, bl));
                }
                break;
            }
            case 102: {
                byte[] byArray7 = new byte[byArray.length - 4];
                System.arraycopy(byArray, 4, byArray7, 0, byArray7.length);
                if (byArray7.length == 0) break;
                BMXJobData bMXJobData = new BMXJobData(byArray7);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.getAutoItem(bMXJobData);
                }
                break;
            }
            case 103: {
                byte[] byArray8 = new byte[4];
                System.arraycopy(byArray, 4, byArray8, 0, 4);
                byte[] byArray9 = new byte[byArray.length - 9];
                System.arraycopy(byArray, 8, byArray9, 0, byArray.length - 9);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.storeAutoItem(byArray8, new String(byArray9));
                }
                break;
            }
            case 104: {
                byte[] byArray10 = new byte[4];
                System.arraycopy(byArray, 4, byArray10, 0, 4);
                byte[] byArray11 = new byte[byArray.length - 9];
                System.arraycopy(byArray, 8, byArray11, 0, byArray.length - 9);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.addAutoItem(byArray10, new String(byArray11));
                }
                break;
            }
            case 105: {
                byte[] byArray12 = new byte[4];
                System.arraycopy(byArray, 4, byArray12, 0, 4);
                byte[] byArray13 = new byte[byArray.length - 9];
                System.arraycopy(byArray, 8, byArray13, 0, byArray.length - 9);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.deleteAutoItem(byArray12, new String(byArray13));
                }
                break;
            }
            case 110: {
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.changeAutoItem();
                }
                break;
            }
            case 53: {
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.setConfig(byArray, n);
                }
                break;
            }
            case 123: {
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.getCrypto(byArray);
                }
                break;
            }
            case 124: {
                short s = (short)(byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8);
                byte[] byArray14 = new byte[byArray.length - 38];
                System.arraycopy(byArray, 38, byArray14, 0, byArray14.length);
                BMXTelegram bMXTelegram = new BMXTelegram(byArray14, true);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.getTraceListeFiltered(s, bMXTelegram);
                }
                break;
            }
            case 125: {
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.rapData(byArray[4]);
                }
                break;
            }
            case 126: {
                String string = ByteConv.byte2string(byArray, 8, byArray.length - 8);
                String[] stringArray = string.split(" ");
                if (stringArray.length != 2) break;
                short s = Short.parseShort(stringArray[0]);
                for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                    iBMXListener.getAstroFunc(s, byArray[2], stringArray[1]);
                }
                break;
            }
            case 129: {
                int n4;
                if (this.enOceanParser == null || (n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8) != 1) break;
                this.enOceanParser.parse(byArray, 9);
                break;
            }
            default: {
                System.out.println("Unbekanntes Datenpaket angekommen: Befehl: " + n2 + " L\u00e4nge: " + n);
            }
        }
    }

    @Override
    public boolean openSocket() {
        System.out.println("creating bmx connection to " + this.hostname + ":" + this.port);
        this.con = new BMXConnectionThread(this);
        boolean bl = this.con.openSocket(this.hostname, this.port);
        if (bl) {
            this.sendPacket(BMXPackets.constructBMXIdentification(0, this.clientname));
            this.sendPacket(BMXPackets.constructBMXIdentification(1, this.clientname));
            this.sendPacket(BMXPackets.constructBMXIdentification(2, this.clientname));
            this.sendPacket(BMXPackets.constructBMXIdentification(3, this.clientname));
            if (this.enocean_online) {
                this.sendPacket(BMXPackets.constructEnOcean(3, new byte[0]));
            }
            if (this.loginType != 0) {
                this.sendPacket(BMXPackets.constructAuthPacket(this.loginType, this.loginId));
            }
            for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                iBMXListener.socketConnectionOpened();
            }
        }
        return bl;
    }

    public boolean openSocket(boolean bl) {
        if (bl) {
            while (!this.openSocket()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
        return this.openSocket();
    }

    public boolean setOnline(boolean bl) {
        if (bl && this.online) {
            for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                iBMXListener.onlineFailed(new BMXException("BMXConnection is already online!"));
            }
        }
        if (!bl && !this.online) {
            for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
                iBMXListener.onlineFailed(new BMXException("BMXConnection is already offline!"));
            }
        }
        if (bl) {
            this.sendPacket(BMXPackets.constructOnlinePacket(this.clientname));
            this.online = true;
        } else {
            this.sendPacket(BMXPackets.constructOfflinePacket());
            this.sendPacket(BMXPackets.constructDisconnectPacket());
            this.online = false;
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void socketConnectionInterrupted() {
        System.out.println("BMXConnection interrupted trying to reconnect");
        for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
            iBMXListener.socketConnectionLost();
        }
        new Thread(this.getClass().getName()){

            @Override
            public void run() {
                do {
                    for (IBMXListener iBMXListener : (IBMXListener[])BMXConnection.this.bmxListeners.getListeners(IBMXListener.class)) {
                        iBMXListener.socketConnectionLost();
                    }
                    System.out.println(new Date() + " reconnect to " + BMXConnection.this.hostname + " failed");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (IBMXListener iBMXListener : (IBMXListener[])BMXConnection.this.bmxListeners.getListeners(IBMXListener.class)) {
                        iBMXListener.socketReconnecting();
                    }
                } while (!this.isInterrupted() && !BMXConnection.this.openSocket());
                if (!this.isInterrupted() && BMXConnection.this.con.isAlive()) {
                    BMXConnection.this.setOnline(true);
                    BMXConnection.this.sendPacket(BMXPackets.constructGetTeleTabelle());
                    for (IBMXListener iBMXListener : (IBMXListener[])BMXConnection.this.bmxListeners.getListeners(IBMXListener.class)) {
                        iBMXListener.socketConnectionEstablished();
                    }
                }
            }
        }.start();
    }

    public boolean closeSocket() {
        System.out.println("closing bmx socket");
        this.setOnline(false);
        this.con.closeSocket();
        return this.online;
    }

    public void sendPacket(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.con.sendPacket(byArray);
        for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
            iBMXListener.sentBMXData(byArray);
        }
    }

    public BMXTelegram getTelegramForAddress(int n) {
        return this.addressTable == null ? null : this.addressTable.getTelegramForAddress(n);
    }

    private void sendTelegramToListeners(BMXTelegram bMXTelegram) {
        for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
            iBMXListener.getTelegram(bMXTelegram);
        }
        if (this.addressTable != null) {
            this.addressTable.insertTelegram(bMXTelegram);
        }
    }

    @Override
    public void sendAddressTableStatus(int n, int n2) {
        for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
            iBMXListener.addressTableStatus(n, n2);
        }
    }

    @Override
    public void addressTableCompleted() {
        for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
            iBMXListener.addressTableCompleted();
        }
    }

    @Override
    public void socketDisconnectionFailed(Exception exception) {
        for (IBMXListener iBMXListener : (IBMXListener[])this.bmxListeners.getListeners(IBMXListener.class)) {
            iBMXListener.socketDisconnectionFailed(exception);
        }
        exception.printStackTrace();
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Double getProtocolVersion() {
        return this.protocolVersion;
    }
}

