/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.sftp;

import de.eibport.net.sftp.BMXKeyListener;
import de.eibport.net.sftp.EibPortSftpException;
import de.eibport.net.sftp.FileInterface;
import de.eibport.net.sftp.KeyStorageInterface;
import de.eibport.net.sftp.SftpContainerListener;
import de.eibport.net.sftp.SftpTransfer;
import java.util.ArrayList;

public class SftpContainer {
    private SftpTransfer fi = null;
    private String host;
    private int sshPort;
    private boolean isInitiated;
    private String error;
    private boolean isReady = false;
    private ArrayList<SftpContainerListener> listener = new ArrayList();
    private KeyStorageInterface keyStorage;

    public SftpContainer(String string, int n, KeyStorageInterface keyStorageInterface) {
        this.host = string;
        this.sshPort = n;
        this.keyStorage = keyStorageInterface;
    }

    public void addSftpContainerListener(SftpContainerListener sftpContainerListener) {
        this.listener.add(sftpContainerListener);
    }

    public void removeSftpContainerListener(SftpContainerListener sftpContainerListener) {
        this.listener.remove(sftpContainerListener);
    }

    private void fireSftpContainerReady() {
        for (SftpContainerListener sftpContainerListener : this.listener) {
            sftpContainerListener.sftpConnectionReady();
        }
    }

    public void init(String string, KeyStorageInterface keyStorageInterface) throws EibPortSftpException {
        this.isReady = this.createFileInterface(string, keyStorageInterface);
        if (!this.isReady) {
            System.out.println("failed connecting ssh");
            throw new EibPortSftpException("Unable to establish secure connection to eibPort. Maybe the given password is wrong or the SSH port (" + this.sshPort + ") is blocked?");
        }
        this.fireSftpContainerReady();
    }

    public void init(final String string) throws EibPortSftpException {
        this.isInitiated = false;
        this.error = null;
        final BMXKeyListener bMXKeyListener = new BMXKeyListener(){

            @Override
            public void finishedReceivingKeys(boolean bl, boolean bl2, KeyStorageInterface keyStorageInterface) {
                if (bl && bl2) {
                    SftpContainer.this.isReady = SftpContainer.this.createFileInterface(string, keyStorageInterface);
                    if (!SftpContainer.this.isReady) {
                        System.out.println("failed connecting ssh");
                        SftpContainer.this.error = "Unable to establish secure connection to eibPort. Maybe the given password is wrong or the SSH port (" + SftpContainer.this.sshPort + ") is blocked?";
                    } else {
                        SftpContainer.this.fireSftpContainerReady();
                    }
                }
                SftpContainer.this.isInitiated = true;
            }

            @Override
            public void keyRequestingFailed(String string2) {
                System.out.println("keyRequestingFailed(" + string2 + ")");
                SftpContainer.this.isInitiated = true;
                SftpContainer.this.error = "Unable to establish a connection to eibPort.(" + string2 + ")";
            }

            @Override
            public void privateKeyReceived(boolean bl, String string2) {
            }

            @Override
            public void publicKeyReceived(boolean bl, String string2) {
            }
        };
        new Thread(){

            @Override
            public void run() {
                SftpContainer.this.keyStorage.init(bMXKeyListener, true, true);
            }
        }.start();
        while (!this.isInitiated) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.error != null) {
            throw new EibPortSftpException(this.error);
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    private boolean createFileInterface(String string, KeyStorageInterface keyStorageInterface) {
        this.fi = new SftpTransfer(this.host, this.sshPort, keyStorageInterface.getUsername(), string, keyStorageInterface);
        return this.fi.testConnection();
    }

    public FileInterface getFileInterface() {
        return this.fi;
    }
}

