/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils;

public class Bfrule {
    private static final int presenTypeEibGroup = 0;
    public static final int presEmpty = 7;
    private static final int presInvalid = 0;
    private static final String presErrorAnswer = "";
    private static final int mask1 = 65535;
    private static final int mask2h = 63488;
    private static final int mask2u = 2047;
    private static final int mask3h = 63488;
    private static final int mask3m = 1792;
    private static final int mask3u = 255;
    private static final int errorAddr = -1;
    private static final char groupSeparator = '/';
    private static final String groupWildcard = "*";
    private static final int rawSize = 10;
    private int recv_mask;
    private int recv_adr;
    private int repl_mask;
    private int repl_adr;
    private int recv_presen;
    private int repl_presen;

    public Bfrule() {
        this.recv_mask = 0;
        this.recv_adr = 0;
        this.repl_mask = 0;
        this.repl_adr = 0;
        this.recv_presen = 7;
    }

    public Bfrule(byte[] byArray, int n) {
        this.parseRaw(byArray, n);
    }

    public void parseRaw(byte[] byArray, int n) {
        this.recv_mask = Bfrule.uB2I(byArray[n + 1]) << 8 | Bfrule.uB2I(byArray[n + 0]);
        this.recv_adr = Bfrule.uB2I(byArray[n + 3]) << 8 | Bfrule.uB2I(byArray[n + 2]);
        this.repl_mask = Bfrule.uB2I(byArray[n + 5]) << 8 | Bfrule.uB2I(byArray[n + 4]);
        this.repl_adr = Bfrule.uB2I(byArray[n + 7]) << 8 | Bfrule.uB2I(byArray[n + 6]);
        this.recv_presen = Bfrule.uB2I(byArray[n + 8]);
        this.repl_presen = Bfrule.uB2I(byArray[n + 9]);
    }

    public byte[] getRaw() {
        byte[] byArray = new byte[]{(byte)this.recv_mask, (byte)(this.recv_mask >>> 8), (byte)this.recv_adr, (byte)(this.recv_adr >>> 8), (byte)this.repl_mask, (byte)(this.repl_mask >>> 8), (byte)this.repl_adr, (byte)(this.repl_adr >>> 8), (byte)this.recv_presen, (byte)this.repl_presen};
        return byArray;
    }

    public static int getRawSize() {
        return 10;
    }

    public int getRecvMask() {
        return this.recv_mask;
    }

    public void setRecvMask(int n) {
        this.recv_mask = n;
    }

    public int getRecvAdr() {
        return this.recv_adr;
    }

    public void setRecvAdr(int n) {
        this.recv_adr = n;
    }

    public int getRecvPres() {
        return this.recv_presen;
    }

    public void setRecvPres(int n) {
        this.recv_presen = n;
    }

    public int getReplMask() {
        return this.repl_mask;
    }

    public void setReplMask(int n) {
        this.repl_mask = n;
    }

    public int getReplAdr() {
        return this.repl_adr;
    }

    public void setReplAdr(int n) {
        this.repl_adr = n;
    }

    public int getReplPres() {
        return this.repl_presen;
    }

    public void setReplPres(int n) {
        this.repl_presen = n;
    }

    public boolean isEmpty() {
        return this.recv_presen == 7 || this.repl_presen == 7;
    }

    private int getType(int n) {
        return n >>> 5 & 7;
    }

    private int setType(int n, int n2) {
        return n & 0x1F | (n2 & 7) << 5;
    }

    private int getGroups(int n) {
        return n >>> 3 & 3;
    }

    private int setGroups(int n, int n2) {
        return n & 0xE7 | (n2 & 3) << 3;
    }

    private int getWCmask(int n) {
        return n >>> 0 & 7;
    }

    private int setWCmask(int n, int n2) {
        return n & 0xF8 | n2 & 7;
    }

    private boolean isHwc(int n) {
        int n2 = this.getWCmask(n);
        return (n2 & 4) == 4;
    }

    private boolean isMwc(int n) {
        int n2 = this.getWCmask(n);
        return (n2 & 2) == 2;
    }

    private boolean isU3wc(int n) {
        int n2 = this.getWCmask(n);
        return (n2 & 1) == 1;
    }

    private boolean isU2wc(int n) {
        int n2 = this.getWCmask(n);
        return (n2 & 3) == 3;
    }

    private int countSlashes(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '/') continue;
            ++n;
        }
        return n;
    }

    private String[] splitAdrs(String string, int n) {
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.indexOf(47, n2);
            stringArray[i] = n3 >= 0 ? string.substring(n2, n3) : string.substring(n2);
            n2 = n3 + 1;
        }
        return stringArray;
    }

    private boolean isWC(String string) {
        boolean bl = string.equals(groupWildcard);
        return bl;
    }

    private int parseInt(String string) throws Exception {
        int n = string.equals(groupWildcard) ? 0 : Integer.parseInt(string);
        return n;
    }

    private String getPresentation(int n, int n2, int n3) {
        String string = new String();
        string = presErrorAnswer;
        if (n3 == 0 || n3 == 7) {
            return string;
        }
        int n4 = (n2 & 0xF800) >>> 11;
        int n5 = (n2 & 0x700) >>> 8;
        int n6 = n2 & 0x7FF;
        int n7 = n2 & 0xFF;
        int n8 = this.getGroups(n3);
        switch (n8) {
            case 1: {
                if (this.isHwc(n3)) {
                    string = string + groupWildcard;
                    break;
                }
                string = string + presErrorAnswer + n2;
                break;
            }
            case 2: {
                string = this.isHwc(n3) ? string + groupWildcard : string + presErrorAnswer + n4;
                string = string + '/';
                if (this.isU2wc(n3)) {
                    string = string + groupWildcard;
                    break;
                }
                string = string + presErrorAnswer + n6;
                break;
            }
            case 3: {
                string = this.isHwc(n3) ? string + groupWildcard : string + presErrorAnswer + n4;
                string = string + '/';
                string = this.isMwc(n3) ? string + groupWildcard : string + presErrorAnswer + n5;
                string = string + '/';
                if (this.isU3wc(n3)) {
                    string = string + groupWildcard;
                    break;
                }
                string = string + presErrorAnswer + n7;
                break;
            }
            default: {
                string = presErrorAnswer;
            }
        }
        return string;
    }

    public String getPresentation(String string) {
        String string2 = new String();
        string2 = string.equals("recv") ? this.getPresentation(this.recv_mask, this.recv_adr, this.recv_presen) : (string.equals("repl") ? this.getPresentation(this.repl_mask, this.repl_adr, this.repl_presen) : "ola: recv " + this.recv_adr + ", repl " + this.repl_adr + ", pres. " + this.recv_presen + " " + this.repl_presen);
        return string2;
    }

    public void parsePresentation(String string, String string2) throws Exception {
        if (!this.tryParsePresentation(string, string2)) {
            throw new IllegalArgumentException("invalid rule");
        }
    }

    public boolean tryParsePresentation(String string, String string2) {
        int[] nArray = this.tryParsePresentation(string);
        if (nArray[2] == 0) {
            return false;
        }
        int[] nArray2 = this.tryParsePresentation(string2);
        if (nArray2[2] == 0) {
            return false;
        }
        this.recv_mask = nArray[0];
        this.recv_adr = nArray[1];
        this.recv_presen = nArray[2];
        this.repl_mask = 0xFFFF ^ nArray2[0];
        this.repl_adr = nArray2[1];
        this.repl_presen = nArray2[2];
        return true;
    }

    private int[] tryParsePresentation(String string) {
        int[] nArray = new int[3];
        if (string.equals(presErrorAnswer)) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 7;
            return nArray;
        }
        int n = this.countSlashes(string) + 1;
        String[] stringArray = this.splitAdrs(string, n);
        int n2 = -1;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                n3 = 0;
                break;
            }
            case 1: {
                try {
                    n2 = this.parseInt(stringArray[0]) & 0xFFFF;
                    if (!this.isWC(stringArray[0])) break;
                    n3 = 7;
                }
                catch (Exception exception) {
                    n2 = -1;
                }
                break;
            }
            case 2: {
                try {
                    n2 = this.parseInt(stringArray[0]) << 11 & 0xF800 | this.parseInt(stringArray[1]) << 0 & 0x7FF;
                    if (this.isWC(stringArray[0])) {
                        if (this.isWC(stringArray[1])) {
                            n3 = 7;
                            break;
                        }
                        n3 = 4;
                        break;
                    }
                    if (!this.isWC(stringArray[1])) break;
                    n3 = 3;
                }
                catch (Exception exception) {
                    n2 = -1;
                }
                break;
            }
            case 3: {
                try {
                    n2 = this.parseInt(stringArray[0]) << 11 & 0xF800 | this.parseInt(stringArray[1]) << 8 & 0x700 | this.parseInt(stringArray[2]) << 0 & 0xFF;
                    if (this.isWC(stringArray[0])) {
                        if (this.isWC(stringArray[1])) {
                            if (this.isWC(stringArray[2])) {
                                n3 = 7;
                                break;
                            }
                            n3 = 6;
                            break;
                        }
                        if (this.isWC(stringArray[2])) {
                            n3 = 5;
                            break;
                        }
                        n3 = 4;
                        break;
                    }
                    if (this.isWC(stringArray[1])) {
                        if (this.isWC(stringArray[2])) {
                            n3 = 3;
                            break;
                        }
                        n3 = 2;
                        break;
                    }
                    if (!this.isWC(stringArray[2])) break;
                    n3 = 1;
                    break;
                }
                catch (Exception exception) {
                    n2 = -1;
                }
            }
        }
        int n4 = 0;
        n4 = this.setType(n4, 0);
        n4 = this.setGroups(n4, n);
        n4 = this.setWCmask(n4, n3);
        int n5 = 65535;
        if ((n3 & 4) == 4) {
            n5 &= 0x7FF;
        }
        if ((n3 & 2) == 2) {
            n5 &= 0xF8FF;
        }
        if ((n3 & 1) == 1) {
            n5 &= 0xFF00;
        }
        if (n2 != -1 && n5 != 0) {
            n2 &= n5;
        }
        if (n2 == -1) {
            n2 = 0;
            n5 = 0;
            n4 = 0;
        }
        nArray[0] = n5;
        nArray[1] = n2;
        nArray[2] = n4;
        return nArray;
    }

    private static int uB2I(byte by) {
        return by & 0xFF;
    }
}

