/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class IniFile {
    protected String basePath;
    protected Vector<String> lines;
    protected Vector<String> subjects;
    protected Vector<Vector> variables;
    protected Vector<Vector> values;
    protected String fileName;
    protected boolean saveOnChange = false;

    public IniFile(String string, String string2) throws IOException {
        this.basePath = string2;
        this.saveOnChange = false;
        this.fileName = string;
        this.loadFile();
        this.parseLines();
    }

    public void loadFile() {
        this.lines = new Vector();
        this.subjects = new Vector();
        this.variables = new Vector();
        this.values = new Vector();
        try {
            URL uRL = new URL(this.basePath + this.fileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(uRL.openStream())));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.lines.addElement(string.trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected boolean createFile() throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.fileName));
        dataOutputStream.writeBytes(";INI File: " + this.fileName + System.getProperty("line.separator"));
        dataOutputStream.close();
        return true;
    }

    protected void parseLines() {
        String string = null;
        for (String string2 : this.lines) {
            if (this.isaSubject(string2)) {
                string = string2.substring(1, string2.length() - 1);
                continue;
            }
            if (!this.isanAssignment(string2)) continue;
            String string3 = string2;
            this.addAssignment(string, string3);
        }
    }

    protected boolean addAssignment(String string, String string2) {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1, string2.length());
        if (string4.length() == 0 || string3.length() == 0) {
            return false;
        }
        return this.addValue(string, string3, string4, false);
    }

    public boolean setValue(String string, String string2, String string3) throws IOException {
        boolean bl = this.addValue(string, string2, string3, true);
        if (this.saveOnChange) {
            this.saveFile();
        }
        return bl;
    }

    protected boolean addValue(String string, String string2, String string3, boolean bl) {
        string2 = string2.trim();
        string3 = string3.trim();
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!this.subjects.contains(string)) {
            this.subjects.addElement(string);
            this.variables.addElement(new Vector());
            this.values.addElement(new Vector());
        }
        int n = this.subjects.indexOf(string);
        Vector vector = this.variables.elementAt(n);
        Vector vector2 = this.values.elementAt(n);
        if (!vector.contains(string2)) {
            vector.addElement(string2);
            vector2.addElement(string3);
        }
        int n2 = vector.indexOf(string2);
        vector2.setElementAt(string3, n2);
        if (bl) {
            this.setLine(string, string2, string3);
        }
        return true;
    }

    protected boolean isaSubject(String string) {
        return string.startsWith("[") && string.endsWith("]");
    }

    protected void setLine(String string, String string2, String string3) {
        int n;
        int n2;
        int n3 = this.findSubjectLine(string);
        if (n3 == -1) {
            this.addSubjectLine(string);
            n3 = this.lines.size() - 1;
        }
        if ((n2 = this.findAssignmentBetween(string2, n3, n = this.endOfSubject(n3))) == -1) {
            this.lines.insertElementAt(string2 + "=" + string3, n);
        } else {
            this.lines.setElementAt(string2 + "=" + string3, n2);
        }
    }

    protected int findAssignmentLine(String string, String string2) {
        int n = this.findSubjectLine(string);
        int n2 = this.endOfSubject(n);
        return this.findAssignmentBetween(string2, n, n2);
    }

    protected int findAssignmentBetween(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.lines.elementAt(i).startsWith(string + "=")) continue;
            return i;
        }
        return -1;
    }

    protected void addSubjectLine(String string) {
        this.lines.addElement("[" + string + "]");
    }

    protected int findSubjectLine(String string) {
        String string2 = "[" + string + "]";
        for (int i = 0; i < this.lines.size(); ++i) {
            String string3 = this.lines.elementAt(i);
            if (!string2.equals(string3)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int n) {
        int n2 = n + 1;
        if (n >= this.lines.size()) {
            return this.lines.size();
        }
        for (int i = n + 1; i < this.lines.size(); ++i) {
            if (this.isanAssignment(this.lines.elementAt(i))) {
                n2 = i + 1;
            }
            if (!this.isaSubject(this.lines.elementAt(i))) continue;
            return n2;
        }
        return n2;
    }

    protected boolean isanAssignment(String string) {
        return string.indexOf("=") != -1 && !string.startsWith(";");
    }

    public Vector getLines() {
        return (Vector)this.lines.clone();
    }

    public String[] getVariables(String string) {
        int n = this.subjects.indexOf(string);
        if (n != -1) {
            Vector vector = this.variables.elementAt(n);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public String[] getSubjects() {
        Object[] objectArray = new String[this.subjects.size()];
        this.subjects.copyInto(objectArray);
        return objectArray;
    }

    public String getValue(String string, String string2) {
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return "";
        }
        Vector vector = this.values.elementAt(n);
        Vector vector2 = this.variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            return (String)vector.elementAt(n2);
        }
        return "";
    }

    public void deleteValue(String string, String string2) throws IOException {
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        Vector vector = this.values.elementAt(n);
        Vector vector2 = this.variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            vector.removeElementAt(n2);
            vector2.removeElementAt(n2);
            int n3 = this.findAssignmentLine(string, string2);
            if (n3 != -1) {
                this.lines.removeElementAt(n3);
            }
            if (vector2.size() == 0) {
                this.deleteSubject(string);
            }
            if (this.saveOnChange) {
                this.saveFile();
            }
        }
    }

    public void deleteSubject(String string) throws IOException {
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        this.values.removeElementAt(n);
        this.variables.removeElementAt(n);
        this.subjects.removeElementAt(n);
        int n2 = this.findSubjectLine(string);
        int n3 = this.endOfSubject(n2);
        for (int i = n2; i < n3; ++i) {
            this.lines.removeElementAt(n2);
        }
        if (this.saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
        for (int i = 0; i < this.lines.size(); ++i) {
            dataOutputStream.writeBytes(this.lines.elementAt(i) + System.getProperty("line.separator"));
        }
        dataOutputStream.close();
    }

    protected void finalize() throws IOException {
        this.saveFile();
    }
}

