/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils.doc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class PrintDialog
extends JDialog {
    public PrintDialog(String string, boolean bl) throws HeadlessException {
        super(JOptionPane.getRootFrame(), bl);
        final MyJEditorPane myJEditorPane = new MyJEditorPane("text/html", string);
        JButton jButton = new JButton("PRINT");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                myJEditorPane.printHTML();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(myJEditorPane), "Center");
        this.getContentPane().add((Component)jButton, "North");
    }

    class MyJEditorPane
    extends JEditorPane
    implements Printable,
    Pageable {
        private PageFormat pf;
        int cnt;

        public MyJEditorPane(String string, String string2) {
            super(string, string2);
            this.cnt = 0;
        }

        void printHTML() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            pageFormat.setOrientation(1);
            this.pf = pageFormat;
            printerJob.setPageable(this);
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            int n2 = this.getBounds().width;
            int n3 = this.getBounds().height;
            int n4 = (int)pageFormat.getImageableHeight();
            int n5 = n * n4;
            if (n5 >= n3) {
                return 1;
            }
            if (this.cnt > 0) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                graphics2D.translate(0, 1 - n5);
                if (n5 + n4 > n3) {
                    n4 = n3 - n5;
                }
                graphics2D.setClip(1, n5 + 1, n2 - 1, n4 - 1);
                this.paint(graphics2D);
                this.cnt = 0;
            }
            ++this.cnt;
            return 0;
        }

        @Override
        public int getNumberOfPages() {
            return (int)((double)this.getBounds().height / this.pf.getImageableHeight()) + 1;
        }

        @Override
        public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
            return this.pf;
        }

        @Override
        public Printable getPrintable(int n) throws IndexOutOfBoundsException {
            return this;
        }
    }
}

