/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.KeyInterpolators;
import org.jdesktop.animation.timing.interpolation.KeyTimes;
import org.jdesktop.animation.timing.interpolation.KeyValues;

public class KeyFrames {
    private KeyValues keyValues;
    private KeyTimes keyTimes;
    private KeyInterpolators interpolators;

    public KeyFrames(KeyValues keyValues) {
        this.init(keyValues, null, new Interpolator[]{null});
    }

    public KeyFrames(KeyValues keyValues, KeyTimes keyTimes) {
        this.init(keyValues, keyTimes, new Interpolator[]{null});
    }

    public KeyFrames(KeyValues keyValues, KeyTimes keyTimes, Interpolator ... interpolatorArray) {
        this.init(keyValues, keyTimes, interpolatorArray);
    }

    public KeyFrames(KeyValues keyValues, Interpolator ... interpolatorArray) {
        this.init(keyValues, null, interpolatorArray);
    }

    private void init(KeyValues keyValues, KeyTimes keyTimes, Interpolator ... interpolatorArray) {
        int n = keyValues.getSize();
        if (keyTimes == null) {
            float f;
            float[] fArray = new float[n];
            fArray[0] = f = 0.0f;
            for (int i = 1; i < n - 1; ++i) {
                fArray[i] = f += 1.0f / (float)(n - 1);
            }
            fArray[n - 1] = 1.0f;
            this.keyTimes = new KeyTimes(fArray);
        } else {
            this.keyTimes = keyTimes;
        }
        this.keyValues = keyValues;
        if (n != this.keyTimes.getSize()) {
            throw new IllegalArgumentException("keyValues and keyTimes must be of equal size");
        }
        if (interpolatorArray != null && interpolatorArray.length != n - 1 && interpolatorArray.length != 1) {
            throw new IllegalArgumentException("interpolators must be either null (implying interpolation for all intervals), a single interpolator (which will be used for all intervals), or a number of interpolators equal to one less than the number of times.");
        }
        this.interpolators = new KeyInterpolators(n - 1, interpolatorArray);
    }

    Class getType() {
        return this.keyValues.getType();
    }

    KeyValues getKeyValues() {
        return this.keyValues;
    }

    KeyTimes getKeyTimes() {
        return this.keyTimes;
    }

    public int getInterval(float f) {
        return this.keyTimes.getInterval(f);
    }

    Object getValue(float f) {
        float f2;
        float f3;
        float f4;
        int n = this.getInterval(f);
        float f5 = this.interpolators.interpolate(n, f4 = (f - (f3 = this.keyTimes.getTime(n))) / ((f2 = this.keyTimes.getTime(n + 1)) - f3));
        if (f5 < 0.0f) {
            f5 = 0.0f;
        } else if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        return this.keyValues.getValue(n, n + 1, f5);
    }
}

